Name: fdutils

%define ver_base 5.5
%define ver_snap 20081027
%define srcname %name-%ver_base

%ifdef ver_snap
Version: %ver_base.%ver_snap
%else
Version: %ver_base
%endif
Release: alt1.qa1

Summary: Programs for dealing with floppy disks
License: GPLv2+
Group: System/Kernel and hardware
Url: http://fdutils.linux.lu
Packager: Dmitry V. Levin <ldv@altlinux.org>

# %url/%srcname.tar.gz
Source: %srcname.tar
%ifdef ver_snap
# %url/%name-%ver_base-%ver_snap.diff.gz
Patch1: %name-%ver_base-%ver_snap.diff
%endif
Patch2: fdutils-5.5-20060227-alt-headers.patch
Patch3: fdutils-5.4-alt-texinfo.patch

Requires: util-linux >= 2.11h-alt2

BuildRequires: flex libe2fs-devel tetex-latex

Summary(ru_RU.KOI8-R):       - 

%description
This package contains utilities for configuring and debugging the
Linux floppy driver, for formatting extra capacity disks (up to 1992K
on a high density disk), for sending raw commands to the floppy
controller, etc.

%description -l ru_RU.KOI8-R
       -,
     ( 1992 ),
     ..

%prep
%setup -q -n %srcname
%ifdef ver_snap
%patch1 -p1
%endif
%patch2 -p1
%patch3 -p1
sed -i 's|<linux/ext2_fs.h>|<ext2fs/ext2_fs.h>|' src/fdmount.c

%build
%configure
# SMP-incompatible
make

%install
mkdir -p %buildroot{%_sysconfdir,%_bindir,%_infodir,%_man1dir,%_man4dir}
%makeinstall UID=$(id -u) GID=$(id -g)

install -p -m644 src/mediaprm %buildroot%_sysconfdir
chmod 755 %buildroot%_bindir/*

%files
%config %_sysconfdir/mediaprm
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc CREDITS Changelog doc/FAQ.html doc/README doc/floppy_formats

%changelog
