BuildRequires: /proc
BuildRequires: jpackage-compat
Name:           fest-reflect
Version:        1.3
Release:        alt1_8jpp7
Summary:        FEST Reflection

Group:          Development/Java
License:        ASL 2.0
URL:            http://fest.easytesting.org

# git clone https://github.com/alexruiz/fest-reflect.git
# cd fest-reflect
# git archive --prefix="fest-reflect-1.3/" --format=tar \
#   1d1da6a9c1f445906c409a1c0df68052ec6d0ad4 | \
#   bzip2 - >../fest-reflect-1.3.tar.bz2
Source0:        %{name}-%{version}.tar.bz2

# bump up the version number of the fest-util dependency
# so that it matches the fedora packaged one
Patch0:         fix-util-version.patch

# fix a spurious failing test
Patch1:         fest-reflect-fix-failing-test.patch

BuildArch:      noarch

BuildRequires:  mockito
BuildRequires:  junit
BuildRequires:  jpackage-utils

BuildRequires:  fest-common = 1.0.11
BuildRequires:  fest-util = 1.2.0
BuildRequires:  fest-test = 1.2.1

BuildRequires:  maven
BuildRequires:  maven-enforcer-plugin
BuildRequires:  maven-surefire
BuildRequires:  maven-surefire-provider-junit4
BuildRequires:  maven-dependency-plugin

Requires:       jpackage-utils
Requires:       fest-common = 1.0.11
Requires:       fest-util = 1.2.0
Source44: import.info

%description
Fluent Interface that simplifies usage of Java Reflection

%package javadoc
Group:          Development/Java
Summary:        Javadoc for %{name}
Requires:       jpackage-utils
BuildArch: noarch

%description javadoc
API documentation for %{name}.

%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
mvn-rpmbuild \
        -e \
        install javadoc:javadoc

%install
# jars
install -d -m 0755 %{buildroot}%{_javadir}
install -m 644 target/%{name}-%{version}.jar  %{buildroot}%{_javadir}/%{name}.jar

# poms
install -d -m 755 %{buildroot}%{_mavenpomdir}
install -pm 644 pom.xml \
    %{buildroot}%{_mavenpomdir}/JPP-%{name}.pom

%add_maven_depmap JPP-%{name}.pom %{name}.jar

# javadoc
install -d -m 0755 %{buildroot}%{_javadocdir}/%{name}
cp -pr target/site/api*/* %{buildroot}%{_javadocdir}/%{name}/

%files
%{_javadir}/*
%{_mavenpomdir}/*
%{_mavendepmapfragdir}/*
%doc LICENSE.txt

%files javadoc
%{_javadocdir}/%{name}
%doc LICENSE.txt

%changelog
