Name:           ffc
Version:        1.1.0
Release:        alt1.bzr20130129
Epoch: 1
Summary:        Compiler for finite element variational forms
Group:          Development/Tools
License:        LGPL v3
URL:            https://launchpad.net/ffc
# bzr branch lp:ffc
Source: %name-%version.tar.gz
Source1: http://www.fenics.org/pub/documents/ffc/ffc-user-manual/ffc-user-manual.pdf
BuildArch: noarch
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Requires: python-module-%name = %epoch:%version-%release

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel
BuildPreReq: libnumpy-devel python-module-fiat python-module-ufc
BuildPreReq: python-module-ferari

%description
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

FFC may be used either from the command line (by invoking the 'ffc' command)
or as a Python module ('import ffc').

FFC is part of the FEniCS project (www.fenics.org) and functions as a
just-in-time (JIT) compiler for DOLFIN.

%package doc
Summary: User manual for FFC
Group: Development/Documentation
BuildArch: noarch

%description doc
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

This package contains user manual for UFL (Unified Form Language).

%package -n python-module-%name
Summary: Python module of FFC
Group: Development/Python
BuildArch: noarch
Requires: python-module-fiat python-module-ufc python-module-ferari
%setup_python_module ffc
%py_provides ffc
%py_requires FIAT ufc ferari
#add_python_req_skip reassign

%description -n python-module-%name
FFC is a compiler for finite element variational forms. From a high-level
description of the form, it generates efficient low-level C++ code that
can be used to assemble the corresponding discrete operator (tensor). In
particular, a bilinear form may be assembled into a matrix and a linear
form may be assembled into a vector.

This package contains python module of FFC.

%prep
%setup

%build
%python_build

%install
%python_build_install --optimize=2

install -d %buildroot%_docdir/%name
install -p -m644 %SOURCE1 %buildroot%_docdir/%name

%files
%doc README TODO AUTHORS ChangeLog COPYING
%_bindir/*
%_man1dir/*

%files doc
%_docdir/%name
%doc demo

%files -n python-module-%name
%python_sitelibdir_noarch/*

%changelog
