%ifarch %ix86
%define archdir arch/x86
%define xfdir xpic
%define x86
%endif
%ifarch x86_64
%define archdir arch/x86_64
%define xfdir xpic_64a
%endif

%define _libexecdir %_prefix/libexec
%define _switchdir %_libexecdir/X11/drv.d
%define new_version 15.11

%define bname fglrx
Name: %{bname}_glx
%define ksname %bname
Epoch: 2
%define real_version 15.30.1025
Version: 15.301.1025
Release: alt1
%define EVR %{?epoch:%epoch:}%version-%release
Summary: ATI/AMD Proprietary Linux Display Driver
Group: System/Kernel and hardware
URL: http://www.amd.com
License: Proprietary
Source0: amd-driver-installer-%real_version-x86.x86_64.run
Source1: atieventsd.service
Source2: %bname-switch.c
Source3: authatieventsd.sh
Source4: amdcccle.desktop
Source5: amdccclesu.desktop
Source7: a-ac-aticonfig
Source8: a-lid-aticonfig
Source9: ati-powermode.sh
Source11: atieventsd.init
Source12: aticonfig.1
Patch0: %bname-13.20.16-printk-loglevel.patch
Patch1: %bname-firegl-4.4.patch
Patch2: %bname-drmP-4.4.patch


%{?epoch:Provides: %{bname}_glx = %version-%release}
Provides: %bname = %EVR
%{?epoch:Provides: %bname = %version-%release}
#Provides: libGL
Provides: xorg-drv-%bname

Requires: xorg-server >= 1.5.0
Requires: libdrm >= 2.4.5-alt2
Requires: libGL libEGL libXrandr libXi libXcursor libXinerama

BuildPreReq: kernel-build-tools
BuildRequires: imake libXaw-devel libXext-devel libXp-devel libXpm-devel xorg-cf-files
BuildRequires: xorg-inputproto-devel xorg-recordproto-devel xorg-xf86miscproto-devel
BuildRequires: xorg-xf86vidmodeproto-devel
BuildRequires: libGL-devel libXrandr-devel libXi-devel libXcursor-devel libXinerama-devel
BuildRequires: libqt4-devel libdmx-devel xorg-xproto-devel
BuildRequires: %_bindir/convert %_bindir/chrpath %_bindir/symlinks
# libX11-devel

ExclusiveArch: %ix86 x86_64

%description
AMD Proprietary Linux Display Driver.
This software suite support following ATI products:
 - ATI Mobility(tm) and Integrated Product Family
 - ATI Desktop and Integrated Product Family
 - All-In-Wonder(tm) variants based on the above are also supported.
   Video capture however is not supported.


%package -n %bname-tools
Summary: Utilities for ATI/AMD Radeon drivers
Group: System/Configuration/Hardware
Requires: %name = %EVR
Requires: acpid
%{?epoch:Provides: %bname-tools = %version-%release}

%description -n %bname-tools
ATI/AMD Radeon configuration utilities:
  - The AMD Catalyst Control Center for ATI Radeon graphics cards.
  - fglrxinfo is an analogue for glxinfo.
  - fgl_glxgears is an analogue for glxgears.
  - aticonfig parses an existing X-Server configuration file and modifies it to
    operate with ATI products.
  - atieventsd is a user-level application that monitors various system events
    such as ACPI or hotplug, then notifies the driver via the X extensions
    interface that the event has occured.

%package doc
Summary: Documentations for ATI/AMD Proprietary Linux Display Driver and tools
Group: Documentation
BuildArch: noarch

%description doc
Documentations for ATI/AMD Proprietary Linux Display Driver and tools.


%package -n kernel-source-%bname
Summary: ATI/AMD %bname (Radeon video card driver) module sources
Group: Development/Kernel
%{?epoch:Provides: kernel-source-%bname = %version-%release}
Provides: kernel-source-%bname-%version = %version-%release
%if "%ksname" == "%bname"
Provides: kernel-src-%bname = %version-%release
%endif

%description -n kernel-source-%bname
ATI/AMD %bname (Radeon video card driver) module sources for Linux kernel.


%prep
%setup -T -c
sh %SOURCE0 --extract .
cd common/lib/modules/%bname/build_mod
#%patch0 -p1
%patch1 -p1
%patch2 -p1

cd -
sed -i '1s|/bash$|/sh|' %archdir/usr/%_lib/%bname/*
for d in {common,%archdir}/lib/modules/%bname/build_mod; do
	find $d -type f -exec chmod 644 \{} \;
done

ln -sf ../../../../../$(ls %archdir/lib/modules/%bname/build_mod/*) common/lib/modules/%bname/build_mod/

install -d -m 0755 %{bname}_tools
tar -C %{bname}_tools -xf common/usr/src/ati/%{bname}_sample_source.tgz

%build
%__cc %optflags -fpic -o %{bname} %SOURCE2

convert common/usr/share/icons/ccc_large.{xpm,png}


%install
install -d -m 0755 %buildroot{%_bindir,%_sbindir}
install -d -m 0755 %buildroot%_libdir/{dri,%bname,X11/{%bname,modules}}
install -d -m 0755 %buildroot{%_datadir/ati/amdcccle,%_liconsdir,%_desktopdir,%_docdir/%name-%version}
install -d -m 0755 %buildroot%_sysconfdir/{acpi/events,ati} %kernel_srcdir

install -p -m 0644 %xfdir/usr/X11R6/%_lib/modules/*.so %buildroot%_x11x11libdir/modules/
install -pD -m 0644 {%xfdir/usr/X11R6/%_lib,%buildroot%_x11x11libdir}/modules/drivers/%{bname}_drv.so
install -pD -m 0644 {%archdir/usr/X11R6/%_lib,%buildroot%_x11x11libdir}/modules/dri/%{bname}_dri.so

ln -sr %buildroot{%_x11x11libdir/modules,%_libdir}/dri/%{bname}_dri.so
ln -sr %buildroot%_x11x11libdir/{modules/dri/%{bname}_,%bname/lib}dri.so
ln -sr %buildroot%_x11x11libdir/{modules/dri/%{bname}_dri.so,%bname/libEGL.so.1}

install -pD -m 0644 {%xfdir/usr/X11R6/%_lib,%buildroot%_x11x11libdir}/modules/linux/lib%{bname}drm.so

ln -s {%bname-,%buildroot%_x11x11libdir/%bname/}libglx.so

install -p -m 0644 {%xfdir/usr/X11R6/%_lib/modules/extensions,%archdir/usr/X11R6/%_lib}/%bname/*  %buildroot%_x11x11libdir/%bname/
ln -s %bname-libGL.so.1.2 %buildroot%_x11x11libdir/%bname/libGL.so.1.2
ln -s libGL.so.1.2 %buildroot%_x11x11libdir/%bname/libGL.so.1
ln -s %bname-libGL.so.1.2 %buildroot%_x11x11libdir/%bname/libGLESv2.so.2


install -d -m 0755 %buildroot%_sysconfdir/X11/%_lib
ln -sr %buildroot{%_x11x11libdir/%bname,%_libdir}/libGL.so.1.2
#ln -sr %buildroot{%_x11x11libdir/%bname,%_sysconfdir/X11/%_lib}/libGL.so.1.2
#ln -s %buildroot{%_sysconfdir/X11/%_lib,%_libdir}/libGL.so.1.2
symlinks -c %buildroot%_libdir

install -p -m 0644 %archdir/usr{/X11R6,}/%_lib/lib* %buildroot%_libdir/
install -p -m 0755 %archdir/usr/%_lib/%bname/* %buildroot%_libdir/%bname/

# tools install
# Create a proper desktop file in the right location

install -m 0644 %SOURCE4 %buildroot/%_desktopdir/
install -m 0644 %SOURCE5 %buildroot/%_desktopdir/
install -pD -m 0644 {common/usr/share/icons/ccc_large,%buildroot%_liconsdir/ccc_large}.xpm
install -p -m 0644 common/usr/share/ati/amdcccle/* %buildroot%_datadir/ati/amdcccle/
for p in amdcccle qt; do
	ls %buildroot%_datadir/ati/amdcccle/${p}_*.qm | sed "s|^%buildroot\(%_datadir/ati/amdcccle/${p}_\(.*\)\.qm\)|%%lang(\2) \1|"
done > %bname-tools.lang
install -p -m 0755 {%archdir,common}/usr/X11R6/bin/* %buildroot%_bindir/

install -p -m 0755 {%archdir,common}%_sbindir/* %buildroot%_sbindir/
install -pD -m644 %SOURCE1 %buildroot%systemd_unitdir/atieventsd.service
install -p -m 0644 %SOURCE7 %SOURCE8 %buildroot%_sysconfdir/acpi/events/
install -p -m 0755 %SOURCE9 %buildroot%_sysconfdir/acpi/
install -pD -m 0755 %SOURCE11 %buildroot%_initrddir/atieventsd
install -pD -m 0644 %SOURCE12 %buildroot%_man1dir/aticonfig.1
install -pD -m 0644 common%_man8dir/* %buildroot%_man8dir/atieventsd.8
install -d -m 0755 %kernel_srcdir
tar -chJ \
	--exclude make.sh \
	--transform 's,common/lib/modules/%bname/build_mod,%ksname-%version,' \
	-f %kernel_srcdir/%ksname-%version.tar.xz \
	common/lib/modules/%bname/build_mod

install -pD -m 0755 {,%buildroot%_switchdir/}%bname

install -d -m 0755 %buildroot%_sysconfdir/ati
install -p -m 0644 common/etc/ati/{*.{blb,default,log},control,signature} %buildroot%_sysconfdir/ati/
install -p -m 0755 %SOURCE3 %buildroot%_sysconfdir/ati/
#%{?x86:install -p -m 0755 common/etc/ati/atiapfxx %buildroot%_sbindir/}
install -p -m 0644 common/{etc/ati/*.example,usr/share/doc/%bname/*.{TXT,html}} %buildroot%_docdir/%name-%version/
for d in articles user-manual; do
	install -d -m 0755 %buildroot%_docdir/%name-%version/$d
	install -p -m 0644 common/usr/share/doc/%bname/$d/* %buildroot%_docdir/%name-%version/$d/
done

chrpath -d %buildroot{%_bindir/amdcccle,%_sbindir/amdnotifyui}

%{?brp_strip_none:%brp_strip_none %_x11x11libdir/fgl*.so}
%set_verify_elf_method textrel=relaxed,unresolved=relaxed,lint=relaxed

%post -n %bname-tools
%post_service atieventsd


%preun -n %bname-tools
%preun_service atieventsd

%postun
ln -sf ../../..%_libdir/X11/libGL.so.1.2 %_sysconfdir/X11/%_lib/libGL.so.1
ln -sf ../..%_sysconfdir/X11/%_lib/libGL.so.1 %_libdir/
ln -sf ../../..%_libdir/X11/libEGL.so.1.0.0 %_sysconfdir/X11/%_lib/libEGL.so.1
ln -sf ../..%_sysconfdir/X11/%_lib/libEGL.so.1 %_libdir/
ln -sf ../../..%_libdir/X11/libGLESv2.so.2.0.0 %_sysconfdir/X11/%_lib/libGLESv2.so.2
ln -sf ../..%_sysconfdir/X11/%_lib/libGLESv2.so.2 %_libdir/
ln -sf ../../..%_libdir/X11/libglx.so %_sysconfdir/X11/%_lib/libglx.so
ln -sf ../..%_sysconfdir/X11/%_lib/libglx.so %_libdir/

%files
%_sysconfdir/ati
%_x11x11libdir/modules/*.so
%_x11x11libdir/modules/dri/*
%_x11x11libdir/modules/drivers/*
%_x11x11libdir/modules/linux
%_libdir/dri
%_x11x11libdir/%bname
%_libdir/%bname
%_libdir/lib*
%exclude %_libdir/*.a
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/LICENSE*
%_switchdir/*
#%_sysconfdir/X11/%_lib/libGL.so.1.*


%files -n %bname-tools -f %bname-tools.lang
%_bindir/*
%_liconsdir/*
%_desktopdir/*
%dir %_datadir/ati
%dir %_datadir/ati/amdcccle
%_sysconfdir/acpi/*
%systemd_unitdir/atieventsd.service
%_initrddir/*
%_man8dir/*
%_man1dir/*
%_sbindir/*


%files -n kernel-source-%bname
%_usrsrc/*


%files doc
%doc %_docdir/%name-%version
%exclude %_docdir/%name-%version/LICENSE*


%changelog
