Name: file
Version: 4.26
Release: alt11

Summary: A utility for determining file types
License: BSD-style
Group: File tools
Url: http://www.darwinsys.com/file/

Summary(ru_RU.UTF-8): Утилита для определения типов файлов
Requires: libmagic = %version-%release
BuildPreReq: zlib-devel

# ftp://ftp.astron.com/pub/file/file-%version.tar.gz
Source: file-%version.tar
Source1: magic.local

Patch: file-%version-%release.patch

%def_enable static

%description
The file command is used to identify a particular file according to the
type of data contained by the file.  file can identify many different
file types, including ELF binaries, system libraries, RPM packages, and
different graphics formats.

%package -n libmagic
Summary: Shared library for handling magic files
Group: System/Libraries

%description -n libmagic
This package contains shared library for handling magic files.

%package -n libmagic-devel
Summary: Development files to build applications that handle magic files
Group: Development/C
Requires: libmagic = %version-%release

%description -n libmagic-devel
This package contains development files to build applications that handle
magic files.

%package -n libmagic-devel-static
Summary: Static library to build statically linked applications that handle magic files
Group: Development/C
Requires: libmagic-devel = %version-%release

%description -n libmagic-devel-static
This package contains static library to build statically linked
applications that handle magic files.

%package -n python-module-magic
Summary: Python bindings for libmagic
Group: Development/Python
Requires: libmagic = %version-%release
%setup_python_module magic

%description -n python-module-magic
This package contains Python bindings for libmagic.

%prep
%setup
%patch -p1
bzip2 -9k ChangeLog

%build
%autoreconf
%configure --enable-fsect-man5 %{subst_enable static}
grep -FZl sparc magic/Magdir/* |
	xargs -r0 sed -i 's/sparc/SPARC/g' --
# SMP-incompatible build.
make

cd python
%python_build

%install
%makeinstall_std
install -pDm644 doc/magic.5 %buildroot%_man5dir/magic.5
install -pDm644 %_sourcedir/magic.local %buildroot%_sysconfdir/magic

# Test for correct identification of Perl modules
find /usr/*/perl5 -type f -name '*.p[lmh]' |
LD_LIBRARY_PATH=%buildroot%_libdir %buildroot%_bindir/file \
	-m %buildroot%_datadir/file/magic -f - >test.out
grep -q ' [Pp]erl.* text' test.out
grep -v ' text' test.out && exit 1

# Provide %_datadir/magic/ for compatibility.
mkdir -p %buildroot%_datadir/magic
ln -s ../file/magic %buildroot%_datadir/magic/

cd python
%python_install

%check
make -k check

%files
%config(noreplace) %_sysconfdir/magic
%_bindir/*
%_datadir/%name
%_datadir/magic
%_man1dir/*
%_man5dir/*
%doc ChangeLog.bz2 COPYING MAINT README

%files -n libmagic
%_libdir/*.so.*

%files -n libmagic-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*

%if_enabled static
%files -n libmagic-devel-static
%_libdir/*.a
%endif

%files -n python-module-magic
%python_sitelibdir/*

%changelog
