%define ver_major 3.8
%def_disable packagekit
%def_disable magic
%def_enable libarchive

%define nau_api_ver 3.0

Name: file-roller
Version: %ver_major.4
Release: alt1.M70P.1

Summary: An archive manager for GNOME
Summary (ru_RU.UTF-8): Архиватор для GNOME 2
License: %gpl2plus
Group: File tools
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Patch: %name-2.28.2-alt-7z.patch
Patch1: %name-3.3.90-alt-zip_command.patch
Patch2: %name-3.7.91-alt-tar.lzo_mime_type.patch
Patch3: %name-3.8.4-rar5-support.patch

# From configure.in
%define glib_ver 2.29.14
%define gtk_ver 3.6.0
%define nautilus_ver 2.91.91
%define libarchive_ver 3.0.0
%define desktop_file_utils_ver 0.8

Requires: tar gzip bzip2 ncompress lzop binutils arj lha unrar zip unzip p7zip lzma-utils
# Requires: cdrecord # for .iso support
Requires: dconf gnome-icon-theme

BuildPreReq: rpm-build-gnome rpm-build-licenses
# From configure.in
BuildPreReq: yelp-tools itstool
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libnautilus-devel >= %nautilus_ver
BuildPreReq: intltool >= 0.35.0
BuildPreReq: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: libSM-devel libjson-glib-devel libnotify-devel
%{?_enable_libarchive:BuildRequires: libarchive-devel >= %libarchive_ver}
%{?_enable_magic:BuildRequires: libmagic-devel}

%description
File Roller is an archive manager for the GNOME environment.  This means that
you can : create and modify archives; view the content of an archive; view a
file contained in the archive; extract files from the archive.
File Roller is only a front-end (a graphical interface) to archiving programs
like tar and zip. The supported file types are :
    * Tar archives uncompressed (.tar) or compressed with
          * gzip (.tar.gz, .tgz)
          * bzip (.tar.bz, .tbz)
          * bzip2 (.tar.bz2, .tbz2)
          * compress (.tar.Z, .taz)
          * lzop (.tar.lzo, .tzo)
    * Ar archives (.ar)
    * Arj archives (.arj)
    * Jar archives (.jar, .ear, .war)
    * Lha archives (.lzh)
    * Rar archives (.rar)
    * Zip archives (.zip)
    * 7-Zip archives (.7z)
    * Single files compressed with gzip, bzip, bzip2, compress, lzop

%description -l ru_RU.UTF-8
File Roller - архиватор для рабочего стола GNOME. С его помощью можно:
создавать архивы и изменять их содержимое, читать оглавление архивов,
просматривать и распаковывать заключенные в архив файлы.
File Roller является графической оболочкой к различным средствам сжатия
данных. В число поддерживаемых программой типов архивов входят:
    * Архивы Tar как несжатые (.tar), так и сжатые посредством
          * gzip (.tar.gz, .tgz)
          * bzip (.tar.bz, .tbz)
          * bzip2 (.tar.bz2, .tbz2)
          * compress (.tar.Z, .taz)
          * lzop (.tar.lzo, .tzo)
    * Ar архивы (.ar)
    * Arj архивы (.arj)
    * Jar архивы (.jar, .ear, .war)
    * Lha архивы (.lzh)
    * Rar архивы (.rar)
    * Zip архивы (.zip)
    * 7-Zip архивы (.7z)
    * Отдельные файлы сжатые при помощи gzip, bzip, bzip2, compress, lzop.

%prep
%setup -q
%patch
%patch1
%patch2 -p1 -b .tzo
%patch3 -p2

rm -f data/%name.desktop{,.in}

%build
%configure \
    --enable-nautilus-actions \
    --disable-schemas-compile \
    --disable-static \
    %{subst_enable magic} \
    %{subst_enable packagekit} \
    %{subst_enable libarchive} \
    --with-smclient=auto

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_libdir/nautilus/extensions-%nau_api_ver/*.so
%dir %_libexecdir/%name
%_libexecdir/%name/*.sh
%_libexecdir/%name/rpm2cpio
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/dbus-1/services/org.gnome.FileRoller.service
%_desktopdir/*
%_iconsdir/hicolor/*/apps/%name.png
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/%name.convert
%doc AUTHORS NEWS README


%exclude %_libdir/nautilus/extensions-%nau_api_ver/*.la

%changelog
