Name: findutils
Version: 4.5.11
Release: alt3

Summary: The GNU versions of find utilities (find and xargs)
License: GPLv3+
Group: File tools
Url: http://www.gnu.org/software/findutils/

# git://git.altlinux.org/gears/f/findutils.git
Source: %name-%version-%release.tar

%def_enable selinux

BuildRequires: gnulib >= 0.0.7902.92f3a4c
BuildRequires: glibc-devel-static
%{?_enable_selinux:BuildRequires: libselinux-devel}
%{?!_without_check:%{?!_disable_check:BuildRequires: dejagnu}}

%package -n find-static
Summary: Static version of the GNU find
Group: File tools
Requires: %name = %version-%release

%description
This package contains programs which will help you locate files on
your system:
+ the find utility searches through a hierarchy of directories
  looking for files which match a certain set of criteria
  (such as a filename pattern);
+ the xargs utility builds and executes command lines from standard
  input arguments (usually lists of file names generated by the find
  command).

%description -n find-static
This package contains statically linked version of the GNU find program.

%prep
%setup -n %name-%version-%release

# Build scripts expect to find findutils version in this file.
echo -n %version > .tarball-version

# Do not build locate.
sed -i 's/ locate / /' Makefile*

echo '@set LOCATE_DB /var/lib/locate/locatedb' >locate/dblocation.texi

bzip2 -9k NEWS

%build
./import-gnulib.sh -d %_datadir/gnulib

%define _configure_script ../configure
mkdir dynamic static

pushd dynamic
mkdir locate
echo '@set LOCATE_DB /var/lib/locate/locatedb' >locate/dblocation.texi
%configure --bindir=/bin %{subst_enable selinux}
make -C po update-po
%make_build MAKEINFOFLAGS=--no-split
popd

pushd static
export	ac_cv_search_setfilecon=no \
	ac_cv_header_selinux_context_h=no \
	ac_cv_header_selinux_flask_h=no \
	ac_cv_header_selinux_selinux_h=no
%configure --disable-nls --disable-selinux
# Do not build xargs and doc.
sed -i -e 's/ xargs / /' -e 's/ doc / /' Makefile*
%make_build
rm find/find
make -C find find LDFLAGS=-static
popd

%install
%makeinstall_std -C dynamic
rm %buildroot{/bin/oldfind,%_man1dir/oldfind.1}
mkdir -p %buildroot%_bindir
for n in find xargs; do
	ln -s "../../bin/$n" %buildroot%_bindir/
done

# Install find.static
install -pm755 static/find/find %buildroot%_bindir/find.static

%find_lang %name

%check
%make_build -k check -C dynamic
%make_build -k check -C static

%files -f %name.lang
/bin/find
/bin/xargs
%_bindir/find
%_bindir/xargs
%_mandir/man?/find*
%_mandir/man?/xargs*
%_infodir/*.info*
%doc AUTHORS NEWS.bz2 README THANKS

%files -n find-static
%_bindir/find.static

%changelog
