%define vname	vimperator
%define mname	muttator
%define vcid vimperator@mozdev.org
%define mcid muttator@mozdev.org
%define vciddir 	%firefox_noarch_extensionsdir/%vcid
%define mciddir 	%tbird_noarch_extensionsdir/%mcid
%define ver 3.8.4
%define mver 1.3
%define ft_release alt2.git20150201
%define workdir %firefox_name-%vname-%ver
%define mworkdir %tbird_name-%mname-%mver

Name: %firefox_name-%vname
Version: %ver
Release: %ft_release
Summary: Browser add-on for Firefox, which makes it like the Vim text editor
Group: Networking/WWW
License: MPL 1.1/GPL 2.0/LGPL 2.1
URL: http://%vname.org/
# https://github.com/vimperator/vimperator-labs/
Source: %firefox_name-%vname-%version.tar.bz2
Source1: asciidoc.tar.bz2
Requires: %firefox_name >= 3.0
Requires: vim
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
BuildArch: noarch
BuildRequires(pre): rpm-build-firefox rpm-build-thunderbird rpm-build-vim
BuildRequires(pre): java-devel-default /proc
BuildPreReq: zip python-modules

%description 
Vimperator is a free browser add-on for Firefox, which makes it look and behave
like the Vim text editor. It has similar key bindings and you could call it a
modal web browser, as key bindings differ according to which mode you are in.

Warning: To provide the most authentic Vim experience, Vimperator hides the
Firefox menubar and toolbar by default. Most users find them unnecessary once
they're used to Vimperator, but if you really need them, type: :set
guioptions+=mT to get them back.

If you don't like Vimperator at all, you can uninstall it by typing :addons and
removing/disabling it. If you like it, but can't remember the shortcuts, press
F1 or :help.

%package -n %tbird_name-%mname
Summary: Add-on for Thunderbird, which makes Thunderbird behave like Vim
Version: %mver
Release: %ft_release
Group: Networking/Mail
BuildArch: noarch
Requires: %tbird_name >= %tbird_version

%description -n %tbird_name-%mname
Muttator is a free browser add-on for Thunderbird, which makes it look and
behave like the Vim text editor. It has similar key bindings, and you could call
it a modal mail client, as key bindings differ according to which mode you are
in.

Warning: To provide the most authentic Vim experience, the Thunderbird menubar
and toolbar were hidden.

If you really need them, type: [set guioptions+=mT to get them back.
If you don't like Muttator at all, you can uninstall it by typing
:addons and remove/disable it.
If you like it, but can't remember the shortcuts, press F1 or :help to get this
help window back.

%prep
%setup
tar -xjf %SOURCE1
subst 's/maxVersion>24\.0/maxVersion>24.*/g' muttator/install.rdf

%build
ln -s asciidoc.py asciidoc/asciidoc
export PATH=$PWD/asciidoc:$PATH
%make_build

mkdir -p _%vname
cp %vname/%{vname}rc.example _%vname/
pushd _%vname
%jar xf ../downloads/%{vname}*.xpi
popd

mkdir -p _%mname
pushd _%mname
%jar xf ../downloads/%{mname}*.xpi
popd

%install
install -d %buildroot%vciddir
install -d %buildroot%mciddir
install -d %buildroot%vim_syntax_dir
install -d %buildroot%vim_ftdetect_dir
cp -fR _%vname/* %buildroot%vciddir/
cp -fR _%mname/* %buildroot%mciddir/
install -m644 %vname/contrib/vim/syntax/%vname.vim \
	%buildroot%vim_syntax_dir/
install -m644 %mname/contrib/vim/syntax/%mname.vim \
	%buildroot%vim_syntax_dir/
install -m644 %vname/contrib/vim/ftdetect/%vname.vim \
	%buildroot%vim_ftdetect_dir/
install -m644 %mname/contrib/vim/ftdetect/%mname.vim\
	%buildroot%vim_ftdetect_dir/

%files
%vciddir
%vim_syntax_dir/%vname.vim
%vim_ftdetect_dir/%vname.vim

%files -n %tbird_name-%mname
%mciddir
%vim_syntax_dir/%mname.vim
%vim_ftdetect_dir/%mname.vim

%changelog
