Name: firmware-linux
Version: 20170113
Release: alt1

Summary: Firmware files used by the Linux kernel
License: GPL+ and GPLv2+ and MIT and Redistributable, no modification permitted
Group: System/Kernel and hardware

Url: git://git.kernel.org/pub/scm/linux/kernel/git/firmware/linux-firmware.git
Source: %name-%version.tar

BuildArch: noarch
Provides: linux-firmware
Provides: firmware-iwl1000 
Provides: firmware-iwl3945 firmware-iwl4965 firmware-iwl5000 firmware-iwl5150 
Provides: firmware-iwl6000 firmware-iwl6050 
Obsoletes: firmware-iwl1000 
Obsoletes: firmware-iwl3945 firmware-iwl4965 firmware-iwl5000 firmware-iwl5150 
Obsoletes: firmware-iwl6000 firmware-iwl6050 
#Requires: firmware-ipw2200 firmware-ipw2100 firmware-ipw3945
Provides:  firmware-carl9170-1.9.4 firmware-i2400m firmware-rt2870 firmware-rt3090
Obsoletes: firmware-carl9170-1.9.4 firmware-i2400m firmware-rt2870 firmware-rt3090
Provides: firmware-amd-ucode
Obsoletes: firmware-amd-ucode <= 2.0

Requires: udev

%description
Kernel-firmware includes firmware files
required for some devices to operate.

%prep
%setup -n %name-%version 

%build
# Remove firmware shipped in separate packages already
# Perhaps these should be built as subpackages of linux-firmware?
## firmware-ql*
rm ql2???_fw.bin LICENCE.qla2xxx
## *TODO* check these too
rm -rf ess korg sb16 yamaha
# We have _some_ ralink firmware in separate packages already.
rm rt73.bin rt2561.bin rt2561s.bin rt2661.bin

# Remove source files we don't need to install
rm -f usbdux/*dux */*.asm *spec

# Fallback symlink in case kernel driver lags behind
# TODO: drop it when we move to 3.19+ or so
ln -s fw_sst_0f28.bin-48kHz_i2s_master intel/fw_sst_0f28.bin-i2s_master

%install
mkdir -p %buildroot/lib/firmware
cp -a * %buildroot/lib/firmware
rm %buildroot/lib/firmware/{WHENCE,LICENCE.*,*.py}

%files
%doc WHENCE LICEN?E.*
/lib/firmware/*
%exclude /lib/firmware/carl9170fw

%changelog
