Name: flex
Version: 2.5.37
Release: alt2

Summary: A fast lexical analyzer generator
License: BSD-style
Group: Development/Other
Url: http://flex.sourceforge.net/

# git://git.altlinux.org/gears/f/%name.git
Source: %name-%version-%release.tar

Requires: m4 >= 0:1.4
Conflicts: flex-old

BuildRequires: flex, help2man
%{?!_without_check:%{?!_disable_check:BuildRequires: gcc-c++}}

%description
flex is a tool for generating scanners: programs which recognized lexical
patterns in text.  flex reads the given input files for a description of a
scanner to generate.  The description is in the form of pairs of regular
expressions and C code, called rules.  flex generates as output a C source
file, lex.yy.c, which defines a routine yylex().  This file is compiled
and linked with the -lfl library to produce an executable.  When the
executable is run, it analyzes its input for occurrences of the regular
expressions.  Whenever it finds one, it executes the corresponding C code.

The behaviour of Flex has undergone a major change since version
2.5.4a.  Flex scanners are now reentrant, you may have multiple
scanners in the same program with differing sets of defaults, and
they play nicer with modern C and C++ compilers.  The Flip side is
that Flex no longer conforms to the POSIX lex behaviour, and the
scanners require conforming implementations when flex is used in ANSI
C mode.  The package flex-old provides the older behaviour.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure
%make_build CFLAGS='%optflags -D_REENTRANT' MAKEINFOFLAGS=--no-split dist_doc_DATA=

%install
%makeinstall_std dist_doc_DATA=

ln -s flex %buildroot%_bindir/lex
ln -s libfl.a %buildroot%_libdir/libl.a
ln -s libfl.a %buildroot%_libdir/libfl_pic.a
ln -s flex.1 %buildroot%_man1dir/lex.1
ln -s flex.1 %buildroot%_man1dir/flex++.1

%find_lang %name

%check
%make_build -k check dist_doc_DATA=

%files -f %name.lang
%doc AUTHORS COPYING NEWS README examples
%_bindir/*
%_libdir/lib*.a
%_includedir/*
%_mandir/man?/*
%_infodir/*.info*

%changelog
