# Optional builds
# _with_mysql
# _with_pgsql
# --with mysql --with pgsql
Name: flow-tools
Version: 0.68
Release: alt6.1.qa1

Summary: Tool set for working with NetFlow data version %version
License: BSD
Group: Monitoring

Url: http://www.splintered.net/sw/flow-tools/
Source: ftp://ftp.eng.oar.net/pub/flow-tools/%name-%version.tar.bz2
Packager: Dmitry Lebkov <dlebkov@altlinux.ru>

Patch1: flow-tools-0.67-shared.patch
Patch2: flow-tools-0.68-alt-config.patch
Patch3: flow-tools-0.68-alt-docs.patch.gz
Patch4: flow-tools-0.68-alt-path.patch
Patch5: flow-tools-0.68-alt-gcc41-compile.patch
Patch6: flow-tools-0.68-alt-x86_64-time.patch

Patch20: flow-tools-0.67-mysql.patch
Patch21: flow-tools-0.68-alt-bug9607.patch

# not used now
Patch102: flow-tools-0.67-config.patch
Patch103: flow-tools-0.67-docs.patch
Patch104: flow-tools-0.67-gcc34.patch
Patch105: flow-tools-0.67-gcc4_amd64.patch
Patch106: flow-tools-0.67-debug.patch


Provides: flow-tools
BuildPreReq: flex zlib-devel %{?_with_mysql: libMySQL-devel} %{?_with_pgsql: postgresql-devel}

# Automatically added by buildreq on Tue Jan 08 2008
BuildRequires: libwrap-devel

Requires: lib%name = %version-%release

%description
Flow-tools is library and a collection of programs used to
collect, send, process, and generate reports from NetFlow data.
The tools can be used together on a single server or distributed
to multiple servers for large deployments. The flow-toools library
provides an API for development of custom applications for NetFlow
export versions 1,5,6 and the 14 currently defined version 8
subversions.

Optional : mysql pgsql
Enabled  :%{?_with_mysql: mysql} %{?_with_pgsql: pgsql}

%package -n lib%name
Summary:        Shared libraries of %{name}
Group:          System/Libraries

%description -n lib%name
Shared libraries of %name.

%package -n lib%name-devel
Summary:        Development headers and libraries for %{name}
Group:          Development/C
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development headers and libraries for %name

%package utils
Summary:        %{name} utilities
Group:          Monitoring
Requires:	%name = %version-%release
BuildArch:	noarch

%description utils
This package contains scripts to provide ASCII, HTML, RRD output

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1

%if_with mysql
%patch20 -p1
%patch21 -p1
%endif

%build
%autoreconf

%configure \
		--disable-static \
    %{?_with_mysql:--with-mysql} \
    %{?_with_pgsql:--with-pgsql}

%make_build

%install
%makeinstall

install -pm644 configs/filter-acl %buildroot/%_sysconfdir/flow-tools/
install -pm644 configs/flow.acl %buildroot/%_sysconfdir/flow-tools/

rm -f %buildroot%_libdir/*.la

%files
%doc  AUTHORS ChangeLog INSTALL README SECURITY TODO contrib docs/*.html
%dir %_sysconfdir/flow-tools/
%dir %_sysconfdir/flow-tools/cfg
%config(noreplace) %_sysconfdir/flow-tools/cfg/*
%_sysconfdir/flow-tools/filter-acl
%_sysconfdir/flow-tools/flow.acl
%dir %_datadir/flow-tools/
%dir %_datadir/flow-tools/sym
%_datadir/flow-tools/sym/*
%_bindir/*
%exclude %_bindir/flow-rpt2rrd
%exclude %_bindir/flow-log2rrd
%exclude %_bindir/flow-rptfmt
%_man1dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
#_libdir/*.a

%files utils
%_bindir/flow-rpt2rrd
%_bindir/flow-log2rrd
%_bindir/flow-rptfmt

%changelog
