%define cvs_date 20031109
%undefine cvs_date
%def_disable static
%def_disable ladcca
%def_enable lash
%def_enable ladspa
%def_disable SSE

Name: fluidsynth
Version: 1.1.6
%define release alt1

%ifdef cvs_date
Release: %{release}cvs%cvs_date
%else
Release: %release
%endif

Summary: Software real-time synthesizer
Summary(ru_RU.KOI8-R):  ,     
Group: Sound
URL: http://www.fluidsynth.org
License: LGPL

%ifdef cvs_date
Source: %name-%version-%cvs_date.tar.bz2
%else
Source: http://savannah.nongnu.org/download/fluid/%name-%version.tar.bz2
%endif
Source1: fluidsynth-autogen.sh

Obsoletes: iiwusynth
Provides: iiwusynth = %version-%release

Requires: lib%name = %version-%release

%define jack_ver 0.75.0
%define ladcca_ver 0.4.0
%define alsa_ver 0.9.8-alt2

%if_enabled ladcca
BuildPreReq: libladcca-devel >= %ladcca_ver
%endif

%if_enabled ladspa
BuildPreReq: ladspa_sdk
%endif

%{?_enable_lash:BuildPreReq: liblash-devel}

BuildPreReq: jackit-devel >= %jack_ver
BuildPreReq: libalsa-devel >= %alsa_ver

# Automatically added by buildreq on Tue Sep 21 2004
#BuildRequires: doxygen gcc-c++ gcc-g77 glib2 jackit-devel ladspa_sdk libalsa-devel libe2fs-devel libladcca-devel libncurses-devel libreadline-devel libstdc++-devel pkgconfig
BuildRequires: gcc-c++ doxygen xsltproc docbook-dtds docbook-style-xsl
BuildRequires: glib2-devel libsndfile-devel jackit-devel libalsa-devel libe2fs-devel
BuildRequires: libncurses-devel libreadline-devel libpulseaudio-devel

%description
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

%description -l ru_RU.KOI8-R
FluidSynth --   ,     
     Soundfont 2.

FluidSynth    MIDI-   
MIDI-.  ,     
MIDI-. FluidSynth    MIDI-, 
 Soundfont.

%package -n lib%name
Summary: Shared libraries for %name
Summary(ru_RU.KOI8-R):    %name
Group: System/Libraries
Obsoletes: libiiwusynth
Provides: libiiwusynth = %version-%release
Requires: libjack >= %jack_ver
%if_enabled ladcca
Requires: libladcca >= %ladcca_ver
%endif
Requires: libalsa >= %alsa_ver

%description -n lib%name
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains libraries for %name package

%description -n lib%name -l ru_RU.KOI8-R
FluidSynth --   ,    
     Soundfont 2.

FluidSynth    MIDI-  
MIDI-.  ,    
MIDI-. FluidSynth    MIDI-,
 Soundfont.

    ,    %name

%package -n lib%name-devel
Summary: Development environment for %name
Summary(ru_RU.KOI8-R):    %name
Group: Development/C
Obsoletes: libiiwusynth-devel
Provides: libiiwusynth-devel = %version-%release
Requires: lib%name = %version-%release
Requires: libalsa-devel >= %alsa_ver
Requires: jackit-devel >= %jack_ver
%if_enabled ladcca
Requires: libladcca-devel >= %ladcca_ver
%endif

%description -n lib%name-devel
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains headers and development files for lib%name package

%description -n lib%name-devel -l ru_RU.KOI8-R
FluidSynth --   ,    
     Soundfont 2.

FluidSynth    MIDI-  
MIDI-.  ,    
MIDI-. FluidSynth    MIDI-,
 Soundfont.

   ,      
%name

%package -n lib%name-devel-static
Summary: Static %name library
Summary(ru_RU.KOI8-R):    %name
Group: Development/C
Obsoletes: libiiwusynth-devel-static
Provides: libiiwusynth-devel-static = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
FluidSynth is a software real-time synthesizer based on the
Soundfont 2 specifications.

FluidSynth reads and handles MIDI events from the MIDI input
device. It is the software analogue of a MIDI synthesizer. FluidSynth
can also play midifiles using a Soundfont.

This package contains static libraries for %name package

%description -n lib%name-devel-static -l ru_RU.KOI8-R
FluidSynth --   ,    
     Soundfont 2.

FluidSynth    MIDI-  
MIDI-.  ,    
MIDI-. FluidSynth    MIDI-,
 Soundfont.

      %name

%prep
%ifdef cvs_date
%setup -q -n %name
%else
%setup -q -n %name-%version
%endif

install -m755 %SOURCE1 ./autogen.sh

%build
%ifdef cvs_date
./autogen.sh
%endif
NOCONFIGURE=1 ./autogen.sh
%configure \
	%{subst_enable static} \
	%{subst_enable ladspa} \
	%{subst_enable ladcca} \
	%{subst_enable lash} \
	--enable-oss-support \
	--enable-alsa-support \
	--enable-jack-support \
	--enable-pulse-support

# Once there was an option for SSE, but buggy configure treats both
# 'enable-SSE' and 'disable-SSE' as SSE-enabling option, thus resulting
# binaries fail to work on most non-Intel processors:
#
#	%{subst_enable SSE} \

%make_build
%make -C doc update-docs

%install
%makeinstall

%files
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS README THANKS NEWS

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*
%doc ChangeLog TODO
%doc doc/{api,html}

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
