%def_disable debug

# Unpackaged files in buildroot should terminate build
%define _unpackaged_files_terminate_build 1

Name: fluxbox
Version: 1.3.7
Release: alt0.M70P.1

Summary: Fast and lightweight window manager
Summary(ru_RU.UTF-8): Легкий и быстрый оконный менеджер

License: MIT
Group: Graphical desktop/Other
Url: http://fluxbox.org

Source0: http://dl.sourceforge.net/fluxbox/fluxbox-%version.tar.bz2
Source1: fluxbox.menu
Source2: fluxbox.menu-methods
Source3: fluxbox.wmsession
Source4: fluxbox-icons.tar.bz2
Source5: README.ALT-ru_RU.UTF-8
Source6: Cthulhain
Source7: fluxbox.vim

# Explanation:
# - xmessages uses by fbsetbg plus can be invoked from menu
# - xprop used in menu item "Window name"
# - xinitrc is owner of /etc/X11/wmsession.d directory
# - menu: support for locate_icon() function
Requires: xmessage xprop xinitrc
Requires: menu >= 2.1.35-alt3

BuildRequires(pre): rpm-build-vim

BuildRequires: gcc-c++ imlib2-devel libXt-devel libXft-devel
BuildRequires: libXrandr-devel libXpm-devel libXinerama-devel libXext-devel

%description
Fluxbox designed for those peoples that unlike huge and feature-overloaded
window manages. It has a lot of good features and one of them it's high speed.
It's very simply for configurate and it compiled with support to KDE and GNOME
applets.

%description -l ru_RU.UTF-8
Fluxbox предназначен для тех, кто не любит навороченные и неповоротливые
оконные менеджеры. Он обладает множеством различных достоинств, главным из
которых является его скорость. Он прост в настройке и скомпилирован с
поддержкой аплетов из KDE и Gnome.

%package -n vim-plugin-fluxbox-syntax
Summary: VIm syntax for fluxbox files
Summary(ru_RU.UTF-8): Подсветка синтаксиса в VIm для fluxbox
Group: Editors
BuildArch: noarch

%description -n vim-plugin-fluxbox-syntax
VIm syntax for fluxbox apps, keys and menu files.

%description -l ru_RU.UTF-8 -n vim-plugin-fluxbox-syntax
Подсветка синтаксиса для конфигурационных файлов fluxbox: app, keys и menu.

%prep
%setup -a4

# Using mouse wheel for changes Tabs
sed -i '22a\
session.screen0.windowScrollAction:\tNextTab
' data/init.in

%build
%autoreconf
%configure \
        --with-init=%_sysconfdir/X11/%name/init \
        --with-keys=%_sysconfdir/X11/%name/keys \
        --with-menu=%_sysconfdir/X11/%name/menu \
        --enable-nls \
        --enable-shape \
        %{?_enable_debug:--enable-debug}

%make_build %{?!_enable_debug: --no-print-directory --silent}

bzip2 ChangeLog

%install
%makeinstall_std %{?!_enable_debug: --no-print-directory --silent}

install -m644 -D 3rd/vim/vim/syntax/fluxapps.vim %buildroot%vim_syntax_dir/fluxapps.vim
install -m644 -D 3rd/vim/vim/syntax/fluxkeys.vim %buildroot%vim_syntax_dir/fluxkeys.vim
install -m644 -D 3rd/vim/vim/syntax/fluxmenu.vim %buildroot%vim_syntax_dir/fluxmenu.vim
install -m644 -D %SOURCE7 %buildroot%vim_ftdetect_dir/fluxbox.vim

%find_lang --custom-dir-script="
s:%buildroot::
s:\(.*/share/fluxbox/nls/\)\(C\|[a-z][^/_@]\+\):%%lang(\2) \1\2:
s:^\([^%%].*\)::
s:%%lang(C) ::" %name

install -pD -m 644 %name-48.xpm %buildroot%_liconsdir/%name.xpm
install -pD -m 644 %name-32.xpm %buildroot%_niconsdir/%name.xpm
install -pD -m 644 %name-16.xpm %buildroot%_miconsdir/%name.xpm

install -pD -m 644 %SOURCE1 %buildroot%_menudir/%name
install -pD -m 755 %SOURCE2 %buildroot%_sysconfdir/menu-methods/%name
install -pD -m 644 %SOURCE3 %buildroot%_sysconfdir/X11/wmsession.d/07%name
install -pD -m 644 %SOURCE5 .
install -pD -m 644 %SOURCE6 %buildroot%_datadir/%name/styles/Cthulhain

%files -f %name.lang
%doc AUTHORS ChangeLog.bz2 COPYING NEWS README* TODO
%_bindir/*
%_man1dir/*
%_man5dir/fluxbox-*.5.*
%_liconsdir/%name.xpm
%_niconsdir/%name.xpm
%_miconsdir/%name.xpm
%_menudir/%name
%_sysconfdir/menu-methods/%name
%config %_sysconfdir/X11/wmsession.d/07%name

%dir %_sysconfdir/X11/%name/
%config %_sysconfdir/X11/%name/[!m]*
%ghost %verify(not mtime md5 size) %_sysconfdir/X11/%name/menu

%dir %_datadir/%name/
%dir %_datadir/%name/nls/
%_datadir/%name/styles/
%_datadir/%name/apps
%_datadir/%name/overlay
%_datadir/%name/windowmenu

%files -n vim-plugin-fluxbox-syntax
%vim_syntax_dir/flux*.vim
%vim_ftdetect_dir/%name.vim

%changelog
