# Patent related warning:
# it is possible to build with --with-freetype-bytecode
# but it is FORBIDDEN in some countries. See documentation
%def_with bytecode

Name: fontforge
Version: 20110222
Release: alt3
Summary: FontForge -- font editor
Summary(ru_RU.KOI8-R):   FontForge

License: BSD
Group: Publishing
Url: http://fontforge.sourceforge.net/

Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %{name}_full-%version.tar.bz2
Source2: %name.png
Patch0: %name-%version.patch

# manually removed: glibc-devel-static packages-info-i18n-common
# Automatically added by buildreq on Mon Oct 29 2007
BuildRequires: gcc-c++ imake libfreetype-devel libjpeg-devel
BuildRequires: libpng-devel libtiff-devel libungif-devel libXi-devel
BuildRequires: libxml2-devel  python-devel xorg-cf-files libX11-devel
BuildPreReq: libfreetype-devel

Obsoletes: pfaedit
Provides: pfaedit

%description
FontForge allows the user to create and modify 
Type 1 (postscript) and true type fonts.
User can save fonts in different postscript 
formats and generate bitmaps.

%description -l ru_RU.KOI8-R
FontForge      
  Type1 (postscipt)  True Type. 
    
 postscript   
  .

%package -n lib%name
Summary: FontForge shared library
Group: System/Libraries

%package -n lib%name-devel
Summary: FontForge development files
Group: Development/C
Requires: lib%name = %version-%release

%package -n python-module-%name
Summary: FontForge python module
Group: Development/Python
Requires: python

%description -n lib%name
FontForge shared library

%description -n lib%name-devel
FontForge development files

%description -n python-module-%name
FontForge python module

%prep
%setup -q
%patch -p0

%build
%add_optflags -fno-strict-aliasing
%configure 	--disable-static \
			--with-freetype-src=%_includedir/freetype2/freetype/internal \
			--with-gdraw \
			--enable-pyextension \
%if_with bytecode
			--with-freetype-bytecode
%else

%endif

sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool

%make_build
pushd pyhook
%python_build
popd

%install
install -D -m644 %SOURCE2 %buildroot%_niconsdir/%name.png

%makeinstall_std

mkdir -p %buildroot%_desktopdir
cat <<EOF >%buildroot%_desktopdir/%name.desktop
[Desktop Entry]
Name=FontForge Font Editor
Comment=Edit and convert fonts
Exec=fontforge %U
Icon=icon-accessories
Terminal=false
Type=Application
Categories=Graphics;Publishing;
MimeType=application/x-font;application/x-font-bdf;application/x-font-ttf;application/x-font-truetype;application/x-truetype-font;application/font-tdpfr;application/x-font-afm;application/x-font-type1;
EOF

pushd pyhook
python setup.py install --root=%buildroot \
                          --optimize=2 \
                          --record=../python-module-%name
popd

%find_lang FontForge

%files -f FontForge.lang
%doc LICENSE
%_bindir/*
%_datadir/%name/
%_man1dir/*
%_desktopdir/%name.desktop
%_niconsdir/*

%files -n lib%name
%_libdir/libgunicode.so.*
%_libdir/libgdraw.so.*
%_libdir/libfontforge.so.*
%_libdir/libgutils.so.*
%_libdir/libgioftp.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/%name/
%_pkgconfigdir/*.pc

%files -n python-module-%name -f python-module-%name

%changelog
