%define oldname serafettin-cartoon-fonts
# %oldname or %version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name serafettin-cartoon-fonts
%define version 0.6
%define fontname serafettin-cartoon
%define fontconf 66-%{fontname}.conf
%define archivename %{oldname}-%{version}

Name:          fonts-ttf-serafettin-cartoon
Version:       0.6
Release:       alt3_5
Summary:       Sans-serif Cartoon Fonts
Group:         System/Fonts/True type
License:       GPLv2+
URL:           http://serafettin.sourceforge.net/
Source0:       http://downloads.sourceforge.net/serafettin/%{archivename}.tar.xz
BuildArch:     noarch

BuildRequires: fontforge
BuildRequires: fontpackages-devel
Source44: import.info


%description
Serafettin aims to be a collection of free Latin fonts for daily usage.
Currently it contains a free cartoon sans-serif font. It is based on Thukkaram 
Gopalrao's TSCu_Comic of tamillinux project. 

%prep
%setup -q -n %{archivename}


%build
export FONTFORGE_VERBOSE=1
make %{?_smp_flags}


%install
rm -fr %{buildroot}

DESTDIR=%{buildroot} make install

install -m 0755 -d %{buildroot}%{_fontconfig_templatedir} \
                   %{buildroot}%{_fontconfig_confdir}

install -m 0644 -p %{fontname}.conf \
        %{buildroot}%{_fontconfig_templatedir}/%{fontconf}
ln -s %{_fontconfig_templatedir}/%{fontconf} \
      %{buildroot}%{_fontconfig_confdir}/%{fontconf}
# generic fedora font import transformations
# move fonts to corresponding subdirs if any
for fontpatt in OTF TTF TTC otf ttf ttc pcf pcf.gz bdf afm pfa pfb; do
    case "$fontpatt" in 
	pcf*|bdf*) type=bitmap;;
	tt*|TT*) type=ttf;;
	otf|OTF) type=otf;;
	afm*|pf*) type=type1;;
    esac
    find $RPM_BUILD_ROOT/usr/share/fonts -type f -name '*.'$fontpatt | while read i; do
	j=`echo "$i" | sed -e s,/usr/share/fonts/,/usr/share/fonts/$type/,`;
	install -Dm644 "$i" "$j";
	rm -f "$i";
	olddir=`dirname "$i"`;
	mv -f "$olddir"/{encodings.dir,fonts.{dir,scale,alias}} `dirname "$j"`/ 2>/dev/null ||:
	rmdir -p "$olddir" 2>/dev/null ||:
    done
done
# kill invalid catalogue links
if [ -d $RPM_BUILD_ROOT/etc/X11/fontpath.d ]; then
    find -L $RPM_BUILD_ROOT/etc/X11/fontpath.d -type l -print -delete ||:
    # relink catalogue
    find $RPM_BUILD_ROOT/usr/share/fonts -name fonts.dir | while read i; do
	pri=10;
	j=`echo $i | sed -e s,$RPM_BUILD_ROOT/usr/share/fonts/,,`; type=${j%%%%/*}; 
	pre_stem=${j##$type/}; stem=`dirname $pre_stem|sed -e s,/,-,g`;
	case "$type" in 
	    bitmap) pri=10;;
	    ttf|ttf) pri=50;;
	    type1) pri=40;;
	esac
	ln -s /usr/share/fonts/$j $RPM_BUILD_ROOT/etc/X11/fontpath.d/"$stem:pri=$pri"
    done ||:
fi


%files
%{_fontconfig_templatedir}/%{fontconf}
%config(noreplace) %{_fontconfig_confdir}/%{fontconf}
%{_fontbasedir}/*/%{_fontstem}/*.ttf

%doc ChangeLog.txt COPYING.txt FONTLOG.txt README.txt
%dir %{_fontbasedir}/*/%{_fontstem}


%changelog
