%define title FooBillard
%define beta %nil

Name: foobillard
Version: 3.0a
Release: alt1.2

Summary: A game of playing billard
License: GPL
Group: Games/Boards

Url: http://foobillard.sunsite.dk/
Source0: %name-%{version}%beta.tar.bz2
Source1: %name
Source3: %name.16.xpm
Source4: %name.32.xpm
Source5: %name.48.xpm
Patch0: foobillard-makefile.patch
Patch1: foobillard-datadir.patch
Patch2: foobillard-3.0a-alt-makefile.patch
# MDK
Patch10: foobillard-3.0-really-disable-nvidia.patch
Packager: Michael Shigorin <mike@altlinux.org>

Requires: sound_handler

# Automatically added by buildreq on Thu May 15 2008 (-bi)
BuildRequires: gcc-c++ imake libSDL-devel libXaw-devel libfreetype-devel libpng-devel xorg-cf-files

BuildRequires: freetype2-devel gcc-c++ libGLU-devel libXi-devel
BuildRequires: libSDL-devel libpng-devel xpm zlib-devel

%description
FooBillard is an attempt to create a free OpenGL-billard for Linux.
The game is still under development but the main physics is implemented.
If you are a billard-pro and you're missing some physics, please tell me.

%prep
%setup -n %name-%version%beta
%patch2 -p1
%patch10 -p1
sed -i 's,LDFLAGS=\(.*\)\$LDFLAGS\(.*\(LIBS\|-l\).*\),LIBS=\1$LIBS\2,' configure.*

%build
%{expand:%%add_optflags %%optflags_kernel %%optflags_notraceback}

%autoreconf
%configure \
    --bindir=%_gamesbindir \
    --datadir=%_gamesdatadir \
    --enable-dependency-tracking \
    --enable-SDL \
    --enable-sound \
    --enable-nvidia=no

%make_build

%install
%makeinstall bindir=%buildroot/%_gamesbindir datadir=%buildroot/%_gamesdatadir

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=%title
Comment=Free OpenGL-billard
Icon=%name
Exec=sound_wrapper.sh %_gamesbindir/%name
Terminal=false
Categories=Game;SportsGame;
EOF

mkdir -p %buildroot/%_iconsdir/hicolor/{16x16,32x32,48x48}/apps/
install -pm0644 %SOURCE3 %buildroot/%_iconsdir/hicolor/16x16/apps/%name.xpm
install -pm0644 %SOURCE4 %buildroot/%_iconsdir/hicolor/32x32/apps/%name.xpm
install -pm0644 %SOURCE5 %buildroot/%_iconsdir/hicolor/48x48/apps/%name.xpm

%files
%doc AUTHORS INSTALL NEWS README ChangeLog TODO README.FONTS foobillardrc.example
%_gamesbindir/*
%_gamesdatadir/%name
%_iconsdir/*/*/apps/%name.xpm
%_desktopdir/%{name}.desktop

%changelog
