Name: freeciv
Version: 2.3.4
Release: alt1

Summary: Turn-based strategy game inspired by the history of human civilization
License: GPLv2+
Group: Games/Strategy
Url: http://www.freeciv.org/

%define srcname %name-%version%{?beta_ver:-beta%beta_ver}
# http://download.sourceforge.net/freeciv/%srcname.tar.bz2
Source0: %srcname.tar
Source1: freeciv-wrapper
# git://git.altlinux.org/gears/f/freeciv.git
Patch: freeciv-%version-%release.patch

Requires: %name-client = %version-%release
Requires: %name-server = %version-%release

# Automatically added by buildreq on Tue Aug 09 2011 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libstdc++-devel pkg-config xorg-xproto-devel
BuildRequires: bzlib-devel gcc-c++ hardlink libgtk+2-devel liblua5-devel libreadline-devel zlib-devel

%package common
Summary: The Freeciv multi-player strategy game common files
Group: Games/Strategy
BuildArch: noarch
Provides: /usr/lib/freeciv/wrapper
Obsoletes: %name-manual < %version

%package -n lib%name
Summary: The Freeciv multi-player strategy game common library
Group: Games/Strategy

%package server
Summary: The Freeciv multi-player strategy game server
Group: Games/Strategy
Requires: %name-common = %version-%release
Requires: lib%name = %version-%release
Requires: %name-server-data = %version-%release

%package server-data
Summary: The Freeciv multi-player strategy game server data files
Group: Games/Strategy
BuildArch: noarch
Conflicts: %name-server < %version-%release

%package client
Summary: The Freeciv multi-player strategy game client
Group: Games/Strategy
Requires: %name-common = %version-%release
Requires: lib%name = %version-%release
Requires: %name-client-data = %version-%release
Provides: %name-client-gui = %version-%release
Provides: %name-client-gtk2 = %version-%release
Provides: %name-client-xaw3d = %version-%release
Obsoletes: %name-client-gtk2, %name-client-xaw3d

%package client-data
Summary: The Freeciv multi-player strategy game client data files
Group: Games/Strategy
BuildArch: noarch
Conflicts: %name-client < %version-%release

%description
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

%description common
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains files common for client ans server.

%description -n lib%name
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains a shared library for client ans server.

%description server
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv server.

%description server-data
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv server data files.

%description client
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv client.

%description client-data
Freeciv is a turn-based, multi-player, X based strategy game.  Freeciv
is generally comparable to, and has compatible rules with, the
Civilization II(R) game by Microprose(R).  In Freeciv, each player is
the leader of a civilization, and is competing with the other players
in order to become the leader of the greatest civilization.

This package contains the Freeciv client data files.

%prep
%setup -n %srcname
%patch -p1
rm -r dependencies/lua-5.1

%build
rm *.m4
%autoreconf

%configure --enable-shared --disable-static --enable-server --enable-client=gtk2 --disable-silent-rules
%make_build MSUBDIRS=

%install
rln()
{
	local target=$1 && shift
	local source=$1 && shift
	target=`relative "$target" "$source"`
	ln -s -nf "$target" "%buildroot$source"
}

%makeinstall_std MSUBDIRS=
rm %buildroot%_libdir/libfreeciv.so

install -pD -m755 %_sourcedir/freeciv-wrapper \
	%buildroot%_libexecdir/%name/wrapper
sed -i 's,@LIBEXECDIR@,%_libexecdir,g' \
	%buildroot%_libexecdir/%name/wrapper
mv %buildroot%_bindir/freeciv-server %buildroot%_libexecdir/%name/
rln %_libexecdir/%name/wrapper %_bindir/freeciv-server

rm %buildroot%_man6dir/freeciv-{gtk2,sdl,xaw}.6
ln -s freeciv-client.6 %buildroot%_man6dir/freeciv-gtk2.6

# docs.
%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -p -m644 AUTHORS NEWS doc/{BUGS,FAQ,HOWTOPLAY,README*,TODO} \
	%buildroot%docdir/

hardlink -cv %buildroot

%find_lang %name

%files

%files common -f %name.lang
%dir %_libexecdir/%name
%_libexecdir/%name/wrapper
%dir %_datadir/%name
%dir %docdir
%docdir/[A-Z]*

%files -n lib%name
%_libdir/libfreeciv.*

%files server
%_bindir/freeciv-server
%dir %_libexecdir/%name
%_libexecdir/%name/freeciv-server

%files server-data
%_desktopdir/%name-server.desktop
%_iconsdir/hicolor/*/apps/%name-server.png
%_man6dir/freeciv-server.*
%_datadir/%name/civ*
%_datadir/%name/default*
%_datadir/%name/experimental*
%_datadir/%name/multiplayer*
%_datadir/%name/nation
%_datadir/%name/scenario

%files client
%_bindir/freeciv-gtk2
%_bindir/freeciv-modpack

%files client-data
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/apps/%name-client.png
%_desktopdir/%name-modpack.desktop
%_iconsdir/hicolor/*/apps/%name-modpack.png
%_pixmapsdir/%name-client.png
%_man6dir/freeciv-client.*
%_man6dir/freeciv-gtk2.*
%_man6dir/freeciv-modpack.*
%_datadir/%name/amplio*
%_datadir/%name/buildings*
%_datadir/%name/flags
%_datadir/%name/freeciv.rc*
%_datadir/%name/gtk*
%_datadir/%name/helpdata.txt
%_datadir/%name/hex2t*
%_datadir/%name/isophex*
%_datadir/%name/misc
%_datadir/%name/stdsounds*
%_datadir/%name/themes
%_datadir/%name/*trident*
%_datadir/%name/wonders*

%changelog
