%define cups_root %_prefix/lib
Name: freenx-server
Version: 0.7.4
Release: alt31.1

Summary: Freenx application/thin-client server
Group: Networking/Remote access
License: GPLv2
Url: http://wiki.etersoft.ru/RX

Packager: Boris Savelev <boris@altlinux.org>

Source: %name-%version.tar
Source1: %name.init
Source2: %name.outformat
Source6: sudoers.conf
Source8: terminate-suspend-nx.sh
Source10: 99-altlinux.conf

Obsoletes: freenx
Provides: freenx = %version

Requires: nx
Requires: openssl
Requires: netcat
Requires: expect
Requires: foomatic-db-engine
Requires: zenity
%if %_vendor == "alt"
Requires: dbus-tools-gui
# FIXME: it needs for strings command, need to be removed
Requires: binutils
Requires: schedutils
%endif

BuildPreReq: rpm-build-intro
BuildRequires: imake xorg-cf-files gccmakedep

%description
Freenx is an application/thin-client server based on nx technology.
NoMachine nx is the next-generation X compression and roundtrip suppression
scheme. It can operate remote X11 sessions over 56k modem dialup links
or anything better. This package contains a free (GPL) implementation
of the nxserver component.

%prep
%setup
# wrong install path
subst "s|/usr/lib|%_libdir|g" nxredir/Makefile
subst "s|%_libdir/cups|%cups_root/cups|g" Makefile
# install use nxloadconfig
subst "s|/usr/lib|%_libdir|g" nxloadconfig
subst "s|%_libdir/cups|%cups_root/cups|g" nxloadconfig
subst "s|\$NX_DIR/lib|%_libdir|g" nxloadconfig
# nxredir nxsmb
subst "s|/usr/lib|%_libdir|g" nxredir/nxredir
subst "s|/usr/lib|%_libdir|g" nxredir/nxsmb
subst "s|/usr/lib|%_libdir|g" %SOURCE10
subst "s|%_libdir/cups|%cups_root/cups|g" nxredir/nxsmb

%build
%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_bindir/
mkdir -p %buildroot%_var/lib/nxserver/home/
mkdir -p %buildroot%_var/lib/nxserver/db/
mkdir -p %buildroot%_sysconfdir/nxserver/node.conf.d/
mkdir -p %buildroot%_sysconfdir/nxserver/acls/
mkdir -p %buildroot%_datadir/%name/node.conf.d/
mkdir -p %buildroot%_sysconfdir/sysconfig/


echo "# See /etc/nxserver/node.conf.d/*.conf" > node.conf

install -Dp -m755 %SOURCE1 %buildroot%_initdir/%name
install -Dp -m755 data/fixkeyboard %buildroot%_sysconfdir/nxserver/fixkeyboard
install -Dp -m755 data/Xsession %buildroot%_sysconfdir/nxserver/Xsession
install -Dp -m644 data/Xkbmap %buildroot%_sysconfdir/nxserver/Xkbmap
install -Dp -m400 %SOURCE6 %buildroot%_sysconfdir/sudoers.d/nxserver
install -Dp -m700 %SOURCE8 %buildroot%_sysconfdir/cron.hourly/terminate-suspend-nx.sh
install -Dp -m644 node.conf %buildroot%_sysconfdir/nxserver/node.conf
install -m644 conf/conf.d/*.conf %buildroot%_datadir/%name/node.conf.d
install -m644 conf/conf.d/*.conf %buildroot%_sysconfdir/nxserver/node.conf.d
install -m644 conf/acls/* %buildroot%_sysconfdir/nxserver/acls
%if %_vendor == "alt"
install -m644 %SOURCE10 %buildroot%_sysconfdir/nxserver/node.conf.d/
%else
install -m755 %SOURCE2 %buildroot%_initdir/
%endif

install -Dp -m644 data/logrotate %buildroot%_sysconfdir/logrotate.d/freenx-server
install -Dp -m644 nx-session-launcher/ConsoleKit-NX.conf %buildroot%_sysconfdir/dbus-1/system.d/ConsoleKit-NX.conf
mv nx-session-launcher/README nx-session-launcher/README.suid

cat >> %buildroot%_sysconfdir/sysconfig/%name << EOF
#Time to live SUSPENDED freenx session in seconds for cron task.
#If not set default value is 3600.
#Cron task enable if value greater than 0.
SESSION_TTL=0
EOF

%pre
%groupadd nx 2> /dev/null ||:
%useradd -g nx -G utmp -d /var/lib/nxserver/home/ -s %_bindir/nxserver \
        -c "NX System User" nx 2> /dev/null ||:
# FIXME: remove it strange code
if [ ! -d %_datadir/fonts/misc ] && [ ! -e %_datadir/fonts/misc ] && [ -d %_datadir/fonts/bitmap/misc ]
then
    ln -s %_datadir/fonts/bitmap/misc %_datadir/fonts/misc
fi

%files
%doc AUTHORS ChangeLog CONTRIB nxcheckload.sample node.conf.sample nx-session-launcher/README.suid
%dir %_sysconfdir/nxserver/
%dir %_sysconfdir/nxserver/node.conf.d/
%dir %_sysconfdir/nxserver/acls/
%config(noreplace) %_sysconfdir/nxserver/node.conf
%config(noreplace) %_sysconfdir/nxserver/node.conf.d/*
%config(noreplace) %_sysconfdir/nxserver/acls/*
%_sysconfdir/nxserver/node.conf.sample
%config(noreplace) %_sysconfdir/logrotate.d/freenx-server
%attr(0400,root,root) %config %_sysconfdir/sudoers.d/nxserver
%config(noreplace) %_sysconfdir/dbus-1/system.d/ConsoleKit-NX.conf
%config(noreplace) %_sysconfdir/nxserver/Xkbmap
%_sysconfdir/nxserver/fixkeyboard
%_sysconfdir/nxserver/Xsession
%config(noreplace) %_sysconfdir/sysconfig/%name
%_sysconfdir/cron.hourly/terminate-suspend-nx.sh
%_initdir/%name
%if %_vendor == "alt"
%else
%_initdir/%name.outformat
%endif
%attr(4711,nx,root) %_bindir/nx-session-launcher-suid
%_bindir/nx*
%dir %_libdir/%name/
%attr(755,root,root) %_libdir/%name/libnxredir.so.0
%cups_root/cups/backend/nx*
%attr(2750,nx,nx) %_var/lib/nxserver/home/
%attr(2750,root,nx) %_var/lib/nxserver/db/
%_datadir/%name/

%changelog
