%def_disable mod_ffmpeg

Name: freerdp
Version: 1.1.0
Release: alt1.M70P.1.beta1

Group: Networking/Remote access
Summary: Remote Desktop Protocol functionality
License: Apache License 2.0
URL: http://www.freerdp.com
Packager: Mikhail Kolchin <mvk@altlinux.org>

Source: FreeRDP-stable-1.1.tar

Requires: xfreerdp = %version-%release %name-plugins-standard = %version-%release

# Automatically added by buildreq on Sun Jun 14 2015
# optimized out: cmake-modules libX11-devel libXext-devel libcloog-isl4 libcom_err-devel libjpeg-devel libkrb5-devel pkg-config xorg-kbproto-devel xorg-renderproto-devel xorg-videoproto-devel xorg-xextproto-devel xorg-xproto-devel zlib-devel
BuildRequires: cmake docbook-style-xsl git-core libXcursor-devel libXinerama-devel libXrender-devel libXv-devel libalsa-devel libcups-devel libdirectfb-devel libjpeg-devel-static libpcsclite-devel libpulseaudio-devel libssl-devel libxkbfile-devel
%if_enabled mod_ffmpeg
libavcodec-devel libavutil-devel
%endif

%description
freerdp implements Remote Desktop Protocol (RDP), used in a number of Microsoft
products. Rdesktop analog.

This is metapackage.


%package -n xfreerdp
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
#Requires: %name-plugins-standard

%description -n xfreerdp
xfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains X11 UI.


%package -n dfreerdp
Summary: Remote Desktop Protocol client
Group: Networking/Remote access
Provides: dfbfreerdp

%description -n dfreerdp
dfbfreerdp is a client for Remote Desktop Protocol (RDP), used in a number of
Microsoft products.

This package contains DirectFB UI.


%package -n lib%name
Summary: Core libraries implementing the RDP protocol
Group: Networking/Remote access

%description -n lib%name
libfreerdp can be embedded in applications.


%package plugins-standard
Summary: Plugins for handling the standard RDP channels
Group: Networking/Remote access
Requires: lib%name = %version-%release

%description plugins-standard
A set of plugins to the channel manager implementing the standard virtual
channels extending RDP core functionality.  For example, sounds, clipboard
sync, disk/printer redirection, etc.


%package -n lib%name-devel
Summary: Libraries and header files for embedding and extending freerdp
Group: Development/Other
Requires: lib%name = %version-%release pkgconfig
Provides: freerdp-devel
Obsoletes: freerdp-devel

%description -n lib%name-devel
Header files and unversioned libraries for libfreerdp.


%prep
%setup -n FreeRDP-stable-1.1

%build
%cmake \
    -DMONOLITHIC_BUILD=OFF \
    -DWITH_ALSA=ON \
    -DWITH_CUPS=ON \
    -DWITH_CHANNELS=ON -DSTATIC_CHANNELS=OFF \
    -DWITH_DIRECTFB=ON \
%if_enabled mod_ffmpeg
    -DWITH_FFMPEG=ON \
%else
    -DWITH_FFMPEG=OFF \
%endif
    -DWITH_GSM=OFF \
    -DWITH_GSTREAMER=OFF \
    -DWITH_IPP=OFF \
    -DWITH_JPEG=ON \
    -DWITH_MANPAGES=OFF \
    -DWITH_OPENSSL=ON \
    -DWITH_PCSC=ON \
    -DWITH_PULSE=ON \
    -DWITH_X11=ON \
    -DWITH_XCURSOR=ON \
    -DWITH_XEXT=ON \
    -DWITH_XKBFILE=ON \
    -DWITH_XI=OFF \
    -DWITH_XINERAMA=ON \
    -DWITH_XRENDER=ON \
    -DWITH_XV=ON \
    -DWITH_ZLIB=ON \
%ifarch x86_64
    -DWITH_SSE2=ON \
%else
    -DWITH_SSE2=OFF \
%endif
%ifarch armh
    -DARM_FP_ABI=hard \
    -DWITH_NEON=OFF \
%endif
    #

%cmake_build

%install
%cmakeinstall_std

rm -f %buildroot%_libdir/*.a \
      %buildroot%_libdir/freerdp/*.a

%files

%files -n xfreerdp
%_bindir/xfreerdp
#%_mandir/*/*

%files -n dfreerdp
%_bindir/dfreerdp

%files -n lib%name
%doc LICENSE README ChangeLog
%_libdir/lib*.so.*
%dir %_libdir/freerdp

%files plugins-standard
%_libdir/freerdp/*.so

%files -n lib%name-devel
%_includedir/freerdp
%_includedir/winpr
%_libdir/lib*.so
%_libdir/pkgconfig/*

%changelog
