Name: fuse-sshfs
Version: 2.4
Release: alt1

Summary: SSH filesystem using FUSE
License: GPLv2
Group: System/Kernel and hardware
Url: http://fuse.sourceforge.net/sshfs.html

Source: http://dl.sourceforge.net/sourceforge/fuse/sshfs-fuse-%version.tar.gz
Patch0: sshfs-fuse-1.8-alt-makefile.patch

Requires: fuse >= 2.3
Requires: openssh-clients

Provides: sshfs-fuse = %version sshfs = %version
Obsoletes: sshfs-fuse < %version sshfs < %version

# Automatically added by buildreq on Wed Sep 26 2012
BuildRequires: glib2-devel libfuse-devel openssh-clients

%description
This is a filesystem client based on the SSH File Transfer Protocol. Since most
SSH servers already support this protocol it is very easy to set up: i.e. on
the server side there's nothing to do. On the client side mounting the 
filesystem is as easy as logging into the server with ssh.

The idea of sshfs was taken from the SSHFS filesystem distributed with LUFS,
which sshfs-fuse's author found very useful. There were some limitations of
that codebase, so he rewrote it. Features of this implementation are:

* Based on FUSE (the best userspace filesystem framework for linux ;-)
* Multithreading: more than one request can be on it's way to the server
* Allowing large reads (max 64k)
* Caching directory contents
* Reconnect on failure

%prep
%setup -q -n sshfs-fuse-%version
%patch0 -p1

%build
%autoreconf
%configure
%make

%install
%makeinstall

%files
%doc AUTHORS FAQ.txt NEWS README
%_bindir/sshfs
%_man1dir/sshfs.*

%changelog
