Name: fvwm
Version: 2.6.5
#define cvsdate 20031019
Release: alt3

%def_with fribidi
%def_with libstroke

%define _unpackaged_files_terminate_build 1

Summary: F(?) Virtual Window Manager
Summary(ru_RU.UTF-8): Мощный оконный менеджер для X Window System
License: GPLv2+
Group: Graphical desktop/FVWM based
Url: http://www.fvwm.org/
Packager: Sergey Vlasov <vsu@altlinux.ru>

%ifdef cvsdate
Source: %name-%cvsdate.tar
%else
# ftp://ftp.fvwm.org/pub/fvwm/version-2/%name-%version.tar.bz2
Source: %name-%version.tar
%endif

Source1: fvwm-2.0.46.icons.tar

Source11: fvwm-compat-icons.tar
Source12: fvwm-menuicon-32.xpm
Source13: fvwm-menuicon.xpm
Source14: Fvwm.xpm
Source15: fvwm.menu
Source16: fvwm.menu-method
Source17: startfvwm
Source18: fvwm.wmsession

Patch1: fvwm-2.5.10-alt-obsolete-modules.patch
Patch2: fvwm-2.6.0-alt-config.patch
Patch3: fvwm-2.6.0-alt-xft-config.patch
Patch4: fvwm-2.5.18-alt-fvwmbug-tmp.patch
Patch6: fvwm-2.5.7-alt-greyed_menu_back.patch
Patch7: fvwm-2.5.14-alt-fonts.patch
Patch8: fvwm-2.6.5-alt-perl-requires.patch
Patch9: fvwm-2.5.16-alt-configure-gdk_imlib.patch
Patch11: fvwm-2.5.23-alt-configure-datarootdir.patch
Patch12: fvwm-2.5.26-alt-bound.patch
Patch13: fvwm-2.5.27-alt-format.patch
Patch14: fvwm-2.5.27-alt-fvwm_msg-echo.patch

%{?_with_fribidi:BuildPreReq: fribidi libfribidi-devel}
%{?_with_libstroke:BuildPreReq: libstroke-devel}

BuildRequires: imlib-devel libXcursor-devel libXft-devel libXinerama-devel libXpm-devel libXt-devel libncurses-devel libreadline-devel perl-GTK perl-Gtk2 perl-Tk perl-X11-Protocol perl-XML-Parser xsltproc

%description
Fvwm is an ICCCM-compliant X window manager providing a 3D look for
window decorations, multiple discontiguous virtual desktops, a high
degree of configurability, and an external module interface for
implementing functional extensions.

%description -l ru_RU.UTF-8
Fvwm - мощный оконный менеджер для X Window System, соответствующий
стандартам ICCCM, с поддержкой множественных виртуальных десктопов.

Эта версия включает в себя новые особенности, такие как цветовые
комплекты (colorsets), соответствие ICCCM2 и совместимость с GNOME,
управление сессий, улучшения во всех модулях, несколько новых модулей,
переработанный код меню, поддержка stroke, Xft2 и многое другое.


%package full
Summary: Fvwm with all available modules
Summary(ru_RU.UTF-8): Fvwm с полным набором модулей
Group: Graphical desktop/FVWM based
Requires: %name-base = %version-%release
Requires: %name-perl = %version-%release
Requires: %name-gtk  = %version-%release
Provides: fvwm95 = %version-%release
Provides: fvwm2  = %version-%release
Provides: fvwm   = %version-%release
Obsoletes: fvwm95, fvwm2, fvwm
BuildArch: noarch

%description full
Fvwm is an ICCCM-compliant X window manager providing a 3D look for
window decorations, multiple discontiguous virtual desktops, a high
degree of configurability, and an external module interface for
implementing functional extensions.

This virtual package installs fvwm with all available modules.

%description -l ru_RU.UTF-8 full
Fvwm - мощный оконный менеджер для X Window System, соответствующий
стандартам ICCCM, с поддержкой множественных виртуальных десктопов.

Эта версия включает в себя новые особенности, такие как цветовые
комплекты (colorsets), соответствие ICCCM2 и совместимость с GNOME,
управление сессий, улучшения во всех модулях, несколько новых модулей,
переработанный код меню, поддержка stroke, Xft2 и многое другое.

Этот виртуальный пакет устанавливает fvwm вместе с полным набором
модулей для него.


%package base
Summary: F(?) Virtual Window Manager - base parts
Summary(ru_RU.UTF-8): Оконный менеджер fvwm с базовым набором модулей
Group: Graphical desktop/FVWM based
Requires: %name-icons = %version-%release, %name-doc = %version-%release
Conflicts: fvwm-themes <= 0.7.0-alt1

%description base
Fvwm is an ICCCM-compliant X window manager providing a 3D look for
window decorations, multiple discontiguous virtual desktops, a high
degree of configurability, and an external module interface for
implementing functional extensions.

This package contains base parts of fvwm, enough for many
configurations.  You may additionally install the %name-perl and
%name-gtk packages to get more features.

%description -l ru_RU.UTF-8 base
Fvwm - мощный оконный менеджер для X Window System, соответствующий
стандартам ICCCM, с поддержкой множественных виртуальных десктопов.

Эта версия включает в себя новые особенности, такие как цветовые
комплекты (colorsets), соответствие ICCCM2 и совместимость с GNOME,
управление сессий, улучшения во всех модулях, несколько новых модулей,
переработанный код меню, поддержка stroke, Xft2 и многое другое.

Этот пакет содержит базовый набор модулей fvwm, достаточный для многих
конфигураций.  При необходимости можно установить пакеты с
дополнительными модулями: %name-perl и %name-gtk.


%package doc
Summary: F(?) Virtual Window Manager - documentation
Summary(ru_RU.UTF-8): Документация для fvwm
Group: Graphical desktop/FVWM based
Conflicts: %name-base < 2.5.26-alt1
BuildArch: noarch

%description doc
This package contains documentation for the fvwm window manager.

%description -l ru_RU.UTF-8 doc
Этот пакет содержит документацию для оконного менеджера fvwm.

%package gtk
Summary: F(?) Virtual Window Manager - FvwmGtk module
Summary(ru_RU.UTF-8): Модуль FvwmGtk для fvwm
Group: Graphical desktop/FVWM based
PreReq: %name-base = %version-%release

%description gtk
Fvwm is an ICCCM-compliant X window manager providing a 3D look for
window decorations, multiple discontiguous virtual desktops, a high
degree of configurability, and an external module interface for
implementing functional extensions.

This package contains the FvwmGtk module, which implements GTK-based
alternatives to the GUI elements in fvwm, namely the builtin menus and
the FvwmForm dialogs.

%description -l ru_RU.UTF-8 gtk
Fvwm - мощный оконный менеджер для X Window System, соответствующий
стандартам ICCCM, с поддержкой множественных виртуальных десктопов.

Эта версия включает в себя новые особенности, такие как цветовые
комплекты (colorsets), соответствие ICCCM2 и совместимость с GNOME,
управление сессий, улучшения во всех модулях, несколько новых модулей,
переработанный код меню, поддержка stroke, Xft2 и многое другое.

Этот пакет содержит модуль FvwmGtk, который позволяет использовать меню
и диалоговые окна в стиле GTK вместо встроенного стиля fvwm.


%package perl
Summary: F(?) Virtual Window Manager - Perl parts
Summary(ru_RU.UTF-8): Модули Perl для fvwm
Group: Graphical desktop/FVWM based
PreReq: %name-base = %version-%release
BuildArch: noarch

%description perl
Fvwm is an ICCCM-compliant X window manager providing a 3D look for
window decorations, multiple discontiguous virtual desktops, a high
degree of configurability, and an external module interface for
implementing functional extensions.

This package contains the FvwmPerl module, fvwm Perl library and other
parts which depend on Perl.

%description -l ru_RU.UTF-8 perl
Fvwm - мощный оконный менеджер для X Window System, соответствующий
стандартам ICCCM, с поддержкой множественных виртуальных десктопов.

Эта версия включает в себя новые особенности, такие как цветовые
комплекты (colorsets), соответствие ICCCM2 и совместимость с GNOME,
управление сессий, улучшения во всех модулях, несколько новых модулей,
переработанный код меню, поддержка stroke, Xft2 и многое другое.

Этот пакет содержит модуль FvwmPerl, библиотеку для написания модулей
fvwm на Perl и другие части fvwm, использующие Perl.


%package icons
Summary: Graphic files used by the fvwm window manager
Summary(ru_RU.UTF-8): Графические файлы для fvwm
Group: Graphical desktop/FVWM based
Provides: fvwm95-icons = %version-%release, fvwm2-icons = %version-%release
Obsoletes: fvwm95-icons, fvwm2-icons
BuildArch: noarch

%description icons
This package contains icons, bitmaps and pixmaps used by the fvwm X
Window System window manager.

%description -l ru_RU.UTF-8 icons
Этот пакет содержит графические файлы, используемые оконным менеджером
fvwm.


%prep
%setup %{?cvsdate:-n fvwm} -a1 -a11

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1

# Fix default fonts.
find -type f -print0 |
	xargs -r0 grep -FZl -e -adobe- -- |
	xargs -r0 subst 's,-adobe-,-*-,g'

%build
%add_optflags -fno-strict-aliasing

# required because of modified Makefile.am
autoreconf -iv

export FVWM_BUGADDR='%packager'
%configure \
	--prefix=%_prefix \
	--bindir=%_bindir \
	--mandir=%_mandir \
	--datadir=%_datadir \
	--libexecdir=%_libexecdir \
	--sysconfdir=%_sysconfdir/X11/%name \
	--with-imagepath=%_miconsdir:%_iconsdir:%_x11includedir/bitmaps \
	--without-termcap-library \
	--with-xft \
	%{?_without_fribidi:--disable-bidi} \
	--enable-htmldoc \
	--without-gnome

%make_build GTK_LIBS="$(pkg-config --libs gtk+)"

%install
%makeinstall_std

# Prepare sample configs.
rm -rf fvwmrc.sample
cp -a sample.fvwmrc fvwmrc.sample
rm -f fvwmrc.sample/Makefile*

# Install default config.
install -pD -m644 $RPM_BUILD_ROOT%_datadir/fvwm/ConfigFvwmSetup \
	$RPM_BUILD_ROOT%_sysconfdir/X11/%name/system.fvwm2rc

# Fake generated menu file.
install -m644 /dev/null $RPM_BUILD_ROOT%_sysconfdir/X11/%name/menu

# Install icons.
rm -rf $RPM_BUILD_ROOT%_iconsdir
mkdir -p $RPM_BUILD_ROOT%_miconsdir
install -pD -m644 icons/*.xpm $RPM_BUILD_ROOT%_iconsdir/
mv $RPM_BUILD_ROOT%_iconsdir/mini*.xpm $RPM_BUILD_ROOT%_miconsdir/

# mdk: Install compatibility icons
install -pD -m644 fvwm-compat-icons/*.xpm $RPM_BUILD_ROOT%_iconsdir
install -pD -m644 fvwm-compat-icons/mini/*.xpm $RPM_BUILD_ROOT%_miconsdir

# mdk: remove conflicting icons.
pushd $RPM_BUILD_ROOT
	rm -f .%_iconsdir/xv.xpm
	rm -f .%_iconsdir/bell.xpm
	rm -f .%_iconsdir/desktop.xpm
	rm -f .%_iconsdir/keyboard.xpm
	rm -f .%_iconsdir/xpaint.xpm
	rm -f .%_iconsdir/xemacs.xpm
	rm -f .%_iconsdir/gv.xpm
popd

# mdk: menu entry icon
install -pD -m644 %SOURCE12 $RPM_BUILD_ROOT%_iconsdir/%name-menuicon.xpm
install -pD -m644 %SOURCE13 $RPM_BUILD_ROOT%_miconsdir/%name-menuicon.xpm
install -p -m644 %SOURCE14 $RPM_BUILD_ROOT%_iconsdir/

# mdk: menu stuff
install -pD -m644 %SOURCE15 $RPM_BUILD_ROOT%_menudir/%name
install -pD -m755 %SOURCE16 $RPM_BUILD_ROOT%_sysconfdir/menu-methods/%name

install -pD -m755 %SOURCE17 $RPM_BUILD_ROOT%_bindir/start%name
install -pD -m644 %SOURCE18 $RPM_BUILD_ROOT%_sysconfdir/X11/wmsession.d/09Fvwm

# move HTML docs to proper place if they were generated
mkdir -p $RPM_BUILD_ROOT/%_docdir/%name
mv $RPM_BUILD_ROOT/%_docdir/%name $RPM_BUILD_ROOT%_docdir/%name-%version

# install additional docs
install -p -m644 AUTHORS COPYING NEWS README \
	docs/ANNOUNCE docs/BUGS docs/FAQ docs/TODO \
	docs/error_codes docs/fvwm.lsm \
	$RPM_BUILD_ROOT%_docdir/%name-%version/

find $RPM_BUILD_ROOT%_docdir/%name-%version -type d -empty -print -delete

%find_lang --output=%name.lang fvwm FvwmScript FvwmTaskBar

%define _perl_lib_path %perl_vendor_privlib:%_datadir/fvwm/perllib

%files base -f %name.lang
%dir %_sysconfdir/X11/%name/
%config(noreplace) %_sysconfdir/X11/%name/system.fvwm2rc
%ghost %_sysconfdir/X11/%name/menu
%_sysconfdir/X11/wmsession.d/*
%_sysconfdir/menu-methods/*
%_bindir/*
%exclude %_bindir/fvwm-convert-2.4
%exclude %_bindir/fvwm-convert-2.6
%exclude %_bindir/fvwm-menu-desktop
%exclude %_bindir/fvwm-menu-directory
%exclude %_bindir/fvwm-menu-headlines
%exclude %_bindir/fvwm-menu-xlock
%exclude %_bindir/fvwm-perllib
%_libexecdir/fvwm
%exclude %_libexecdir/fvwm/%version/FvwmCommand.pm
%exclude %_libexecdir/fvwm/%version/FvwmConsoleC.pl
%exclude %_libexecdir/fvwm/%version/FvwmDebug
%exclude %_libexecdir/fvwm/%version/FvwmGtk
%exclude %_libexecdir/fvwm/%version/FvwmGtkDebug
%exclude %_libexecdir/fvwm/%version/FvwmPerl
%exclude %_libexecdir/fvwm/%version/FvwmTabs
%exclude %_libexecdir/fvwm/%version/FvwmWindowMenu
%_datadir/fvwm/
%exclude %_datadir/fvwm/perllib/
%exclude %_datadir/fvwm/ConfigFvwmTabs
%exclude %_datadir/fvwm/FvwmTabs-DefaultSetup
%exclude %_datadir/fvwm/fvwm-script-ComExample.pl
%exclude %_datadir/fvwm/fvwm-script-setup95.pl
%_menudir/*

%files doc
%_mandir/man?/*
%exclude %_mandir/man1/FvwmConsoleC.pl.1*
%exclude %_mandir/man1/FvwmDebug.1*
%exclude %_mandir/man1/FvwmGtkDebug.1*
%exclude %_mandir/man1/FvwmPerl.1*
%exclude %_mandir/man1/FvwmTabs.1*
%exclude %_mandir/man1/FvwmWindowMenu.1*
%exclude %_mandir/man1/fvwm-convert-2.4.1*
%exclude %_mandir/man1/fvwm-convert-2.6.1*
%exclude %_mandir/man1/fvwm-menu-desktop.1*
%exclude %_mandir/man1/fvwm-menu-directory.1*
%exclude %_mandir/man1/fvwm-menu-headlines.1*
%exclude %_mandir/man1/fvwm-menu-xlock.1*
%exclude %_mandir/man1/fvwm-perllib.1*
%_docdir/%name-%version

%files full
# virtual package

%files gtk
%_libexecdir/fvwm/%version/FvwmGtk

%files perl
%_bindir/fvwm-convert-2.4
%_bindir/fvwm-convert-2.6
%_bindir/fvwm-menu-desktop
%_bindir/fvwm-menu-directory
%_bindir/fvwm-menu-headlines
%_bindir/fvwm-menu-xlock
%_bindir/fvwm-perllib
%_libexecdir/fvwm/%version/FvwmCommand.pm
%_libexecdir/fvwm/%version/FvwmConsoleC.pl
%_libexecdir/fvwm/%version/FvwmDebug
%_libexecdir/fvwm/%version/FvwmGtkDebug
%_libexecdir/fvwm/%version/FvwmPerl
%_libexecdir/fvwm/%version/FvwmTabs
%_libexecdir/fvwm/%version/FvwmWindowMenu
%_datadir/fvwm/perllib/
%_datadir/fvwm/ConfigFvwmTabs
%_datadir/fvwm/FvwmTabs-DefaultSetup
%_datadir/fvwm/fvwm-script-ComExample.pl
%_datadir/fvwm/fvwm-script-setup95.pl
%_mandir/man1/FvwmConsoleC.pl.1*
%_mandir/man1/FvwmDebug.1*
%_mandir/man1/FvwmGtkDebug.1*
%_mandir/man1/FvwmPerl.1*
%_mandir/man1/FvwmTabs.1*
%_mandir/man1/FvwmWindowMenu.1*
%_mandir/man1/fvwm-convert-2.4.1*
%_mandir/man1/fvwm-convert-2.6.1*
%_mandir/man1/fvwm-menu-desktop.1*
%_mandir/man1/fvwm-menu-directory.1*
%_mandir/man1/fvwm-menu-headlines.1*
%_mandir/man1/fvwm-menu-xlock.1*
%_mandir/man1/fvwm-perllib.1*

%files icons
%_iconsdir/*.xpm
%_miconsdir/*.xpm

%changelog
