Name: gawk
Version: 4.0.2
Release: alt3

%def_with doc
%def_with profile
%define _libexecdir %prefix/libexec

Summary: The GNU version of the awk text processing utility
License: GPLv3+
Group: Text tools
Url: http://www.gnu.org/software/gawk/

# git://git.altlinux.org/gears/g/gawk.git
Source: %name-%version-%release.tar

Provides: awk = %version
BuildRequires: libreadline-devel
# Automatically added by buildreq on Sat Sep 22 2012
# optimized out: fontconfig fonts-type1-urw ghostscript-classic ghostscript-common gnu-config groff-base tex-common texlive-base texlive-base-bin texlive-common texlive-latex-base tzdata
%{?_with_doc:BuildRequires: ghostscript-utils groff-ps texlive-generic-recommended}

%description
This packages contains the GNU version of awk, a text processing utility.
Awk interprets a special-purpose programming language to do quick
and easy text pattern matching and reformatting jobs.  Gawk should be
upwardly compatible with the Bell Labs research version of awk and is
almost completely compliant with the 1993 POSIX 1003.2 standard for awk.

%package profile
Summary: The version of gawk with profiling support
Group: Development/Other
Requires: %name = %version-%release

%description profile
This package includes pgawk (profiling gawk).  pgawk is identical in
every way to gawk, except that when it has finished running, it creates
a profile of your program with line execution counts.

%package -n dgawk
Summary: The awk Debugger
Group: Development/Other
Requires: %name = %version-%release

%description -n dgawk
This package includes dgawk -- the awk debugger.

%package doc
Summary: Documentation about the GNU version of the awk text processing utility
Group: Text tools
BuildArch: noarch
Requires: %name = %version-%release

%description doc
This packages contains documentation about the GNU version of the awk
text processing utility.

%prep
%setup -n %name-%version-%release

%build
./bootstrap.sh
rm awkgram.c command.c version.c doc/*.info awklib/eg/prog/igawk.sh awklib/stamp-eg
%configure --bindir=/bin --without-libsigsegv-prefix
%make_build
%if_with doc
cd doc
%make_build gawk.dvi awkcard.pdf
dvipdf gawk.dvi
cd -
%endif

%install
%makeinstall_std
rm %buildroot/bin/*-%{version}*
mkdir -p %buildroot%_bindir
mv %buildroot/bin/?gawk %buildroot%_bindir/
ln -s ../../bin/gawk %buildroot%_bindir/
ln -s gawk %buildroot%_bindir/awk
ln -s gawk.1 %buildroot%_man1dir/awk.1

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 AUTHORS ChangeLog FUTURES LIMITATIONS NEWS POSIX.STD README \
	%{?_with_doc:doc/{gawk,awkcard}.pdf} %buildroot%docdir/

%find_lang %name

%check
%make_build -k check diffout

%files -f %name.lang
/bin/*
%_bindir/*
%exclude %_bindir/dgawk

%if_with profile
%exclude %_bindir/pgawk
%endif #with profile

%_libexecdir/awk
%_datadir/awk
%_infodir/*.info*
%_mandir/man?/*
%exclude %_man1dir/dgawk.*

%dir %docdir
%docdir/[A-Z]*

%files -n dgawk
%_bindir/dgawk

%if_with profile
%files profile
%_bindir/pgawk
%endif #with profile

%if_with doc
%files doc
%dir %docdir
%docdir/*.pdf
%endif

%changelog
