Name: gcc-common
Version: 1.4.16
Release: alt1

Summary: Common directories, symlinks and selection utility for the GNU Compiler Collection
License: GPL
Group: Development/C

Source0: select-gcc.in
Source1: gccbug.in
Source2: gcc_wrapper.c
Source3: classpath.security
Source4: libgcj.security
Source5: logging.properties

Patch: gccbug-alt.patch

PreReq: alternatives >= 0:0.4

%define _libexecdir /usr/libexec

%ifarch ppc ppc64
# On powerpc, even though target is ppc32, compiler is inherently 64-bit,
# thus the wrapper should call ppc64-alt-linux-*.
%define _target_platform ppc64-alt-linux
%endif

%package -n gcc-c++-common
Summary: Common symlinks for the GNU C++ Compiler
License: GPL
Group: Development/C++
BuildArch: noarch
PreReq: %name = %version-%release

%package -n gcc-go-common
Summary: Common symlinks for the Go Compiler
License: GPL
Group: Development/Other
BuildArch: noarch
PreReq: %name = %version-%release

%package -n gcc-fortran-common
Summary: Common symlinks for the GNU Fortran Compiler
License: GPL
BuildArch: noarch
Group: Development/Other
PreReq: %name = %version-%release
Provides: gcc-g77-common = %version-%release
Obsoletes: gcc-g77-common
Conflicts: gcc2.95-g77 < 1:2.95.3-alt8
Conflicts: gcc2.96-g77 < 0:2.96-alt8
Conflicts: gcc3.3-g77 < 0:3.3.4-alt5
Conflicts: gcc3.4-g77 < 0:3.4.5-alt3

%package -n gcc-treelang-common
Summary: Common symlinks for the GNU Treelang Compiler
License: GPL
Group: Development/Other
BuildArch: noarch
PreReq: %name = %version-%release
Conflicts: gcc3.3-treelang < 0:3.3.4-alt5
Conflicts: gcc3.4-treelang < 0:3.4.5-alt3

%package -n gcc-java-common
Summary: Common symlinks for the GNU Java Compiler
License: GPL
Group: Development/Java
BuildArch: noarch
PreReq: %name = %version-%release
Requires: fastjar
Conflicts: gcc3.4-java < 0:3.4.5-alt3

%package -n libgcj-common
Summary: Common files for the GNU Java runtime libraries
License: GPL
Group: Development/Java
PreReq: %name = %version-%release
Conflicts: libgcj < 0:3.3.3-alt6

%description
This package contains common symlinks, directories and selection
utility for the GNU Compiler Collection.

%description -n gcc-c++-common
This package contains common symlinks for the GNU C++ Compiler.

%description -n gcc-go-common
This package contains common symlinks for the Go Compiler.

%description -n gcc-fortran-common
This package contains common symlinks for the GNU Fortran 77 Compiler.

%description -n gcc-treelang-common
This package contains common symlinks for the GNU Treelang Compiler.

%description -n gcc-java-common
This package contains common symlinks for the GNU Java Compiler.

%description -n libgcj-common
This package contains common files for the GNU Java runtime libraries.

%prep
%setup -cT
install -p -m755 %SOURCE0 select-gcc
install -p -m755 %SOURCE1 gccbug
install -p -m755 %SOURCE2 %SOURCE3 %SOURCE4 %SOURCE5 .

%patch -p1

%build
gcc %optflags -Werror -D_GNU_SOURCE '-DBINDIR="%_bindir"' \
	'-DTARGET="%_target_platform"' gcc_wrapper.c -o gcc_wrapper
sed -i 's|@TARGET@|%_target_platform|g' select-gcc gccbug

%install
mkdir -p %buildroot{/lib,%_libdir/gcc{,-lib}/%_target_platform,%_libexecdir/gcc/%_target_platform,%_libdir/security,%_bindir,%_sbindir,%_includedir/c++,%_datadir/java/gcj-endorsed}
install -p -m755 select-gcc %buildroot%_sbindir/
install -p -m755 gcc_wrapper %buildroot%_bindir/
install -p -m755 gccbug %buildroot%_bindir/%_target_platform-gccbug
install -p -m644 logging.properties %buildroot%_libdir/
install -p -m644 {classpath,libgcj}.security %buildroot%_libdir/security/

ln -s gcc_wrapper %buildroot%_bindir/gcc

for n in cc cpp g++ gccgo gcj gcov gfortran gtreelang protoize unprotoize; do
	ln -s gcc "%buildroot%_bindir/$n"
done
for n in gappletviewer gcj-dbtool gcjh gij gjar gjarsigner gjavah gjnih gkeytool gorbd grmic grmid grmiregistry gserialver gtnameserv jcf-dump jv-convert jv-scan; do
	ln -s gcj "%buildroot%_bindir/$n"
done

for n in f77 f95 g77; do
	ln -s gfortran "%buildroot%_bindir/$n"
done

ln -s ..%_bindir/cpp %buildroot/lib/cpp
ln -s g++ %buildroot%_bindir/c++
ln -s gtreelang %buildroot%_bindir/tree1
ln -s %_target_platform-gccbug %buildroot%_bindir/gccbug

mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name<<EOF
%_bindir/gcc	%_bindir/gcc_wrapper	40
EOF

%files
%config %_altdir/%name
/lib/*
%_libdir/gcc*
%_libexecdir/gcc*
%exclude %_bindir/gcc
%_bindir/gcc_wrapper
%_bindir/cc
%_bindir/cpp
%_bindir/gccbug
%_bindir/gcov
%_bindir/protoize
%_bindir/unprotoize
%_bindir/%_target_platform-gccbug
%_sbindir/*

%files -n gcc-c++-common
%_bindir/c++
%_bindir/g++
%_includedir/c++

%files -n gcc-fortran-common
%_bindir/f77
%_bindir/f95
%_bindir/g77
%_bindir/gfortran

%files -n gcc-go-common
%_bindir/gccgo

%files -n gcc-treelang-common
%_bindir/gtreelang
%_bindir/tree1

%files -n gcc-java-common
%_bindir/gappletviewer
%_bindir/gcj
%_bindir/gcj-dbtool
%_bindir/gcjh
%_bindir/gij
%_bindir/gjar
%_bindir/gjarsigner
%_bindir/gjavah
%_bindir/gjnih
%_bindir/gkeytool
%_bindir/gorbd
%_bindir/grmic
%_bindir/grmid
%_bindir/grmiregistry
%_bindir/gserialver
%_bindir/gtnameserv
%_bindir/jcf-dump
%_bindir/jv-convert
%_bindir/jv-scan

%files -n libgcj-common
%_datadir/java/
%_libdir/logging.properties
%_libdir/security

%changelog
