Name:           gdcm
Version:        2.2.3
Release:        alt2.M70P.1
Summary:        DiCoM is a C++ library for DICOM medical files
Group:          System/Libraries
License:        BSD
URL:            http://sourceforge.net/projects/gdcm/
Source:         %name-%version.tar

Patch6: gdcm-2.0.17-install2libarch.patch
Patch10: gdcm-2.0.17-no_versioned_dir.patch

BuildRequires: doxygen tetex-latex cmake gcc-c++ libvtk-devel libexpat-devel zlib-devel libuuid-devel libopenjpeg-devel libssl-devel libCharLS-devel libpoppler-devel
BuildRequires: /proc java-1.6.0-sun-devel swig mono-mcs mono-devel vtk-python
#BuildRequires: php5 php5-devel python-devel

%description
Grassroots DiCoM is a C++ library for DICOM medical files. It is wrapped to Python,
C#, Java and PHP. It supports RAW, JPEG, J2K, JPEG-LS, RLE and deflated.
It supports SCU network operations (C-ECHO, C-FIND, C-STORE, C-MOVE).
Part 3/6 are XML files.

%package 	doc
Summary:        Libraries for %name
Group:          Documentation

%description	doc
The %name-doc package contains documentation for %name

%package -n	lib%name
Summary:        Libraries for %name
Group:          System/Libraries

%description -n	lib%name
The lib%name package contains libraries for %name

%package -n	lib%name-devel
Summary:        Development files for %name
Group:          System/Libraries
Requires:       lib%name = %version-%release

%description -n	lib%name-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n	lib%name-java
Summary:        Grassroots DICOM Java bindings
Group:          System/Libraries

%description -n	lib%name-java
Grassroots DiCoM is a C++ library for DICOM medical files. It is
automatically wrapped to python/C#/Java (using swig). It supports
RAW,JPEG (lossy/lossless),J2K,JPEG-LS, RLE and deflated.

Java bindings to the GDCM DICOM library. It allows developers to use
GDCM from Java environment.

%package -n	lib%name-vtk
Summary:        Grassroots DICOM vtk bindings
Group:          System/Libraries

%description -n	lib%name-vtk
Grassroots DiCoM is a C++ library for DICOM medical files. It is
automatically wrapped to python/C#/Java (using swig). It supports
RAW,JPEG (lossy/lossless),J2K,JPEG-LS, RLE and deflated.

VTK bindings to the GDCM DICOM library.

%prep
%setup -q
%patch6 -p 1
%patch10 -p 1

sed -i '28,36d' CMakeLists.txt

%build
%cmake \
	-DCMAKE_VERBOSE_MAKEFILE=ON \
	-DCMAKE_SKIP_RPATH:BOOL=YES \
	-DGDCM_BUILD_APPLICATIONS:BOOL=ON \
	-DGDCM_BUILD_SHARED_LIBS:BOOL=ON \
	-DGDCM_DOCUMENTATION:BOOL=ON \
	-DGDCM_PDF_DOCUMENTATION:BOOL=OFF \
	-DGDCM_BUILD_TESTING:BOOL=OFF \
	-DCMAKE_BUILD_TYPE:STRING="Release" \
	-DGDCM_BUILD_EXAMPLES:BOOL=OFF \
	-DGDCM_WRAP_PYTHON:BOOL=OFF \
	-DGDCM_WRAP_CSHARP:BOOL=ON \
	-DGDCM_WRAP_JAVA:BOOL=ON \
	-DGDCM_WRAP_PHP:BOOL=OFF \
	-DPHP5_FOUND_INCLUDE_PATH=$(php-config --include-dir) \
	-DGDCM_USE_VTK:BOOL=ON \
	-DGDCM_USE_SYSTEM_EXPAT:BOOL=ON \
	-DGDCM_USE_SYSTEM_ZLIB:BOOL=ON \
	-DGDCM_USE_SYSTEM_UUID:BOOL=ON \
	-DGDCM_USE_SYSTEM_OPENJPEG:BOOL=ON \
	-DGDCM_USE_SYSTEM_OPENSSL:BOOL=ON \
	-DGDCM_USE_SYSTEM_CHARLS:BOOL=ON \
	-DGDCM_USE_SYSTEM_LJPEG=OFF \
	-DGDCM_USE_SYSTEM_POPPLER=ON \
	-DGDCM_USE_JPEGLS=ON \
	-DGMCS_EXECUTABLE=/usr/bin/gmcs

%make_build -C BUILD

%install
%makeinstall_std -C BUILD

%files
%doc AUTHORS AUTHORS README.*
%_bindir/*
%_datadir/%name
%_man1dir/*

%files doc
%_defaultdocdir/%name

%files -n lib%name
%_libdir/lib%{name}*.so.*
%_libdir/libsocketxx.so.*
%_libdir/%{name}*.dll


%files -n lib%name-devel
%_libdir/*.so
%_libdir/%name
%_includedir/%name
#_libdir/pkgconfig/*.pc

%exclude %_libdir/lib%{name}jni.so

%files -n lib%name-java
%_libdir/lib%{name}jni.so
%_libdir/gdcm.jar

%files -n lib%name-vtk
%_libdir/libvtk*.so.*
%_libdir/vtk%{name}*.dll


%changelog
