%define ver_major 3.8
%define api_ver 1.0

%define _libexecdir %_prefix/libexec
%define _localstatedir %_var

%define authentication_scheme pam
#%%define default_pam_config altlinux
%define default_pam_config redhat
# Initial virtual terminal to use
%define vt_nr 7

%def_disable static
%def_disable debug
%def_enable ipv6
%def_with xinerama
%def_with xdmcp
%def_with tcp_wrappers
%def_with selinux
%def_without consolekit
%def_with systemd
%def_with libaudit
%def_with plymouth
%def_without xevie
%def_disable split_authentication
# https://git.gnome.org/browse/gdm/commit/?id=acc931c762b5510103a7f49cf3074c1228700cb8
%def_disable fallback_greeter

Name: gdm
Version: %ver_major.4
Release: alt1

Summary: The GNOME Display Manager
License: GPLv2+
URL: ftp://ftp.gnome.org/
Group: Graphical desktop/GNOME
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %name-%version.tar.xz
Source1: gdm_xdmcp.control
Source2: gdm.wms-method

# PAM config files
Source10: gdm.pam
Source11: gdm-autologin.pam
Source12: gdm-password.pam
Source13: gdm-launch-environment.pam
#Source11: gdm-smartcard.pam
#Source12: gdm-fingerprint.pam

Patch2: gdm-3.2.1.1-alt-Xsession.patch
Patch7: gdm-3.1.92-alt-Init.patch
Patch9: gdm-3.2.2-alt-link.patch
Patch10: gdm-3.2.1.1-alt-invalid_user_shell.patch
Patch11: gdm-3.8.0-alt-lfs.patch

Obsoletes: %name-gnome
Provides: %name-gnome = %version-%release

# from configure.ac
%define dbus_glib_ver 0.74
%define glib_ver 2.35
%define gtk_ver 2.91.1
%define pango_ver 1.3.0
%define scrollkeeper_ver 0.1.4
%define libcanberra_ver 0.4
%define fontconfig_ver 2.5.0
%define upower_ver 0.9.0
%define accountsservice_ver 0.6.12
%define nss_ver 3.11.1
%define check_ver 0.9.4

Provides: %name-user-switch-applet = %version-%release
Obsoletes: %name-user-switch-applet

PreReq: %_rpmlibdir/update-dconf-database.filetrigger
Requires: %name-libs = %version-%release
%{?_with_consolekit:Requires: ConsoleKit-x11}
%{?_disable_fallback_greeter:Requires: gnome-shell}
Requires: coreutils consolehelper zenity xinitrc iso-codes lsb-release shadow-utils

BuildPreReq: desktop-file-utils gnome-common rpm-build-gnome
BuildPreReq: intltool >= 0.40.0 yelp-tools itstool
BuildPreReq: libdbus-glib-devel >= %dbus_glib_ver
BuildPreReq: iso-codes-devel
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libpango-devel >= %pango_ver
BuildPreReq: libupower-devel >= %upower_ver
BuildPreReq: libaccountsservice-devel >= %accountsservice_ver
%{?_with_consolekit:BuildPreReq: libConsoleKit-devel}
%{?_with_systemd:BuildRequires: systemd-devel libsystemd-login-devel libsystemd-daemon-devel libsystemd-journal-devel}
%{?_with_selinux:BuildPreReq: libselinux-devel libattr-devel}
%{?_with_libaudit:BuildPreReq: libaudit-devel}
%{?_with_plymouth:BuildPreReq: plymouth-devel}
BuildPreReq: libpam-devel
%{?_with_tcp_wrappers:BuildPreReq: libwrap-devel}
BuildPreReq: libcanberra-devel >= %libcanberra_ver libcanberra-gtk3-devel
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: libX11-devel libXau-devel libXrandr-devel libXext-devel libXdmcp-devel libXft-devel libSM-devel
BuildPreReq: libXi-devel xorg-inputproto-devel libXinerama-devel xorg-xineramaproto-devel libXevie-devel
BuildPreReq: xorg-xephyr xorg-server
BuildPreReq: libcheck-devel >= %check_ver
BuildPreReq: libnss-devel >= %nss_ver

BuildRequires:  gcc-c++ libdmx-devel
BuildRequires: librsvg-devel perl-XML-Parser docbook-dtds xsltproc zenity
BuildRequires: gobject-introspection-devel
# for check
BuildRequires: /proc dbus-tools-gui xvfb-run

%description
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

%package libs
Summary: GDM libraries
Group: System/Libraries

%description -n %name-libs
This package contains shared libraries needed for GNOME Display Manager
to work.

%package libs-devel
Summary: Development files for GDM libraries
Group: Development/C
Requires: %name-libs = %version-%release

%description libs-devel
This package contains headers and development libraries for GNOME
Display Manager.

%package libs-gir
Summary: GObject introspection data for the GDM
Group: System/Libraries
Requires: %name-libs = %version-%release

%description libs-gir
GObject introspection data for the GDM libraries.

%package libs-gir-devel
Summary: GObject introspection devel data for the GDM
Group: Development/Other
BuildArch: noarch
Requires: %name-libs-gir = %version-%release
Requires: %name-libs-devel = %version-%release

%description libs-gir-devel
GObject introspection devel data for the GDM libraries.

%package help
Summary: User documentation for Gdm
Group: Graphical desktop/GNOME
BuildArch: noarch
Conflicts: %name < %version-%release

%description help
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains user documentation for Gdm.

%package extension-fingerprint
Summary: Fingerprint extension for Gdm
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description extension-fingerprint
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains Fingerprint extension for Gdm.

%package extension-smartcard
Summary: Smartcard extension for Gdm
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description extension-smartcard
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains Smartcard extension for Gdm.

%package gnome
Summary: GNOME-specific part of Gdm
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: %name = %version-%release
Provides: gnome-dm
Conflicts: %name < 2.28.0-alt1
Requires: gnome-session >= 3.7.1
Requires: polkit-gnome >= 0.105 gnome-settings-daemon >= 3.7.1

%description gnome
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

Install this package for use with GNOME desktop.

%prep
%setup -q
%patch2 -p1
%patch7 -p1
#%%patch9 -p1 -b .link
#%%patch10 -p1 -b .shells
%patch11 -p1 -b .lfs

# just copy our PAM config files to %default_pam_config directory
cp %SOURCE10 %SOURCE11 %SOURCE12 %SOURCE13 data/pam-%default_pam_config/

%build
[ ! -d m4 ] && mkdir m4
%autoreconf
%configure \
	%{subst_enable static} \
	--disable-schemas-compile \
	--enable-console-helper \
	--enable-authentication-scheme=%authentication_scheme \
	%{subst_enable ipv6} \
	%{subst_enable debug} \
	--with-sysconfsubdir=X11/gdm \
	%{subst_with xinerama} \
	%{subst_with xdmcp} \
	%{?_with_tcp_wrappers:--with-tcp-wrappers} \
	%{?_with_consolekit:--with-console-kit} \
	%{subst_with systemd} \
	--with-pam-prefix=%_sysconfdir \
	--with-default-pam-config=%default_pam_config \
	%{subst_with xevie} \
	%{subst_with libaudit} \
	%{subst_with plymouth} \
	--with-default-path="/bin:/usr/bin:/usr/local/bin" \
	%{?_disable_split_authentication:--disable-split-authentication} \
	--with-initial-vt=%vt_nr \
	--with-authentication-agent-directory=%_libexecdir/polkit-1 \
	--with-dmconfdir=%_sysconfdir/X11/sessions \
	--disable-dependency-tracking \
	%{?_enable_fallback_greeter:--enable-fallback-greeter}

%make_build

%install
mkdir -p %buildroot%_sysconfdir/X11/sessions
mkdir -p %buildroot%_sysconfdir/X11/wms-methods.d

%makeinstall_std

# create empty default dconf database updated from dconf posttrans filetrigger
touch %buildroot/%_sysconfdir/dconf/db/gdm

# install external hook for update_wms
install -m755 %SOURCE2 %buildroot%_sysconfdir/X11/wms-methods.d/%name

find %buildroot -name '*.a' -delete
find %buildroot -name '*.la' -delete

# control gdm/xdmcp
install -pDm755 %SOURCE1 %buildroot%_controldir/gdm_xdmcp

%find_lang %name
%find_lang --output=%name-help.lang --without-mo --with-gnome %name

# tests
#mkdir -p %_libexecdir/%name/tests
#find ./ -executable -type f -name "*test*" -print0| xargs -r0 install -pD -m 755 -t %_libexecdir/%name/tests/ --

%check
xvfb-run %make check

%pre
%pre_control gdm_xdmcp

%post
%post_control -s disabled gdm_xdmcp

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README TODO
%config %_sysconfdir/pam.d/gdm
%config %_sysconfdir/pam.d/gdm-autologin
%config %_sysconfdir/pam.d/gdm-password
%config %_sysconfdir/pam.d/gdm-launch-environment
%config %_sysconfdir/dbus-1/system.d/%name.conf
%config %_datadir/glib-2.0/schemas/org.gnome.login-screen.gschema.xml
%config(noreplace) %_sysconfdir/X11/%name
%config %_sysconfdir/dconf/profile/gdm
%ghost %_sysconfdir/dconf/db/gdm
%dir %_sysconfdir/dconf/db/gdm.d
%_sysconfdir/dconf/db/gdm.d/00-upstream-settings
%dir %_sysconfdir/dconf/db/gdm.d/locks
%_sysconfdir/dconf/db/gdm.d/locks/00-upstream-settings-locks
%dir %_sysconfdir/X11/sessions
%config %_controldir/gdm_xdmcp
%_sysconfdir/X11/wms-methods.d/%name
%_unitdir/gdm.service
%_bindir/*
%_sbindir/*
%_libexecdir/*
%dir %_datadir/%name
%_datadir/%name/locale.alias
%_datadir/%name/gdb-cmd
%_datadir/%name/%name.schemas
%dir %_datadir/%name/greeter
%dir %_datadir/%name/greeter/applications
%dir %_datadir/%name/greeter/autostart
%_datadir/%name/greeter/applications/polkit-gnome-authentication-agent-1.desktop
%_pixmapsdir/*
%_datadir/icons/*/*/*/*.*
%dir %_localstatedir/log/gdm
%attr(775, gdm, gdm) %dir %_localstatedir/cache/gdm
%attr(1770, gdm, gdm) %dir %_localstatedir/lib/gdm
%attr(1750, gdm, gdm) %dir %_localstatedir/lib/gdm/.local
%attr(1750, gdm, gdm) %dir %_localstatedir/lib/gdm/.local/share
%attr(1777, root, gdm) %dir %_localstatedir/run/gdm

# obsolete -gnome subpackage
%_datadir/gdm/greeter/applications/gnome-shell.desktop
%_datadir/gdm/greeter/applications/mime-dummy-handler.desktop
%_datadir/gdm/greeter/applications/gdm-simple-greeter.desktop
%_datadir/gdm/greeter/applications/mimeapps.list
%_datadir/gnome-session/sessions/gdm-shell.session
%exclude %_datadir/gdm/greeter/autostart/orca-autostart.desktop

# fallback greeter
%_datadir/gdm/gdm-greeter-login-window.ui
%_datadir/gdm/simple-greeter/
%_datadir/gnome-session/sessions/gdm-fallback.session

%if_enabled split_authentication
#%_libdir/gdm/simple-greeter/extensions/libpassword.so
%dir %_datadir/gdm/simple-greeter/extensions/password
%_datadir/gdm/simple-greeter/extensions/password/page.ui
%endif

%files help -f %name-help.lang


%files libs
%_libdir/libgdm.so.*
%_libdir/libgdmsimplegreeter.so.*

%files libs-devel
%_includedir/gdm/
%_libdir/libgdm.so
%_libdir/libgdmsimplegreeter.so
%_libdir/pkgconfig/gdm.pc
%_libdir/pkgconfig/gdmsimplegreeter.pc

%files libs-gir
%_typelibdir/Gdm-%api_ver.typelib

%files libs-gir-devel
%_girdir/Gdm-%api_ver.gir

%exclude %_sysconfdir/pam.d/gdm-pin

# TODO
%if_enabled split_authentication
%files extension-fingerprint
%_sysconfdir/pam.d/gdm-fingerprint
%_libdir/gdm/simple-greeter/extensions/libfingerprint.so
%dir %_datadir/gdm/simple-greeter/extensions/fingerprint
%_datadir/gdm/simple-greeter/extensions/fingerprint/page.ui

%files extension-smartcard
%_sysconfdir/pam.d/gdm-smartcard
%_libdir/gdm/simple-greeter/extensions/libsmartcard.so
%dir %_datadir/gdm/simple-greeter/extensions/smartcard
%_datadir/gdm/simple-greeter/extensions/smartcard/page.ui
%endif

%changelog
