%define ver_major 2.20
%define base_name gdm

%define _libexecdir %_libdir/%base_name
%define authentication_scheme pam
%def_disable static
%def_enable ipv6
%def_with xinerama
%def_with xdmcp
%def_with tcp_wrappers
%def_without selinux
%def_with consolekit
%def_with libaudit
%def_disable polkit

Name: gdm2.20
Version: %ver_major.8
Release: alt9

Summary: The GNOME Display Manager
License: GPLv2+
Group: Graphical desktop/GNOME

Url: ftp://ftp.gnome.org/
Source0: ftp://ftp.gnome.org/pub/gnome/sources/%base_name/%ver_major/%base_name-%version.tar
Source1: gnomedesktop.png
Source3: gdm_xdmcp.control
Source4: gdm-termok-command

# ALT patches
Patch1: %base_name-2.20.8-alt-config.patch
Patch2: %base_name-2.20.6-alt-xsession.patch
Patch3: %base_name-2.20.4-alt-alias.patch
Patch4: %base_name-2.20.0-alt-grep.patch
Patch5: %base_name-2.20.8-alt-change-path-to-gdmsetup.patch
Patch6: %base_name-2.20.8-alt-pam.patch
Patch7: %base_name-2.20.8-alt-fix-dso-linking.patch
Patch8: %base_name-2.20.8-alt-termok.patch

# RH patches
Patch19: %base_name-2.19.3-move-default-message.patch
Patch20: %base_name-2.19.5-reset-pam.patch
Patch28: %base_name-2.17.1-desensitize-entry.patch
# http://bugzilla.gnome.org/show_bug.cgi?id=411501 
Patch33: %base_name-2.19.6-pass-ats-to-session.patch
# http://bugzilla.redhat.com/show_bug.cgi?id=246399 
Patch43: %base_name-2.20.1-keymouselistener-segfault.patch

Packager: Alexander Borovsky <partizan@altlinux.org>

Requires: coreutils consolehelper zenity xinitrc
BuildPreReq: desktop-file-utils intltool gnome-common gnome-doc-utils libglade-devel libxml2-devel

Provides: gdm = %version
Conflicts: gdm < %version
Conflicts: gdm > %version

# Automatically added by buildreq on Wed Dec 03 2008
BuildRequires: docbook-dtds gcc-c++ gnome-doc-utils-xslt imake intltool libSM-devel libXau-devel libXdmcp-devel libXext-devel libXi-devel libXinerama-devel libdbus-glib-devel libdmx-devel libgnomecanvas-devel libpam-devel libpopt-devel librsvg-devel libwrap-devel xorg-cf-files xsltproc zenity xorg-server

%description
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

%package help
Summary: User documentation for Gdm
Group: Graphical desktop/GNOME
Conflicts: %base_name < %version-%release
Conflicts: %base_name > %version-%release
Provides: gdm-help = %version
BuildArch: noarch
Conflicts: gdm-help < %version
Conflicts: gdm-help > %version

%description help
Gdm (the GNOME Display Manager) is a highly configurable
reimplementation of xdm, the X Display Manager. Gdm allows you to log
into your system with the X Window System running and supports running
several different X sessions on your local machine at the same time.

This package contains user documentation for Gdm.

%prep
%setup -n gdm-%version

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p2
%patch6 -p1
%patch7 -p1
%patch8 -p2

%patch19 -p1
%patch20 -p1
%patch28 -p1
%patch33 -p1
%patch43 -p1

# This hack forces configure to use libwrap.
subst 's,libwrap.a,libwrap.so,' configure

%build
export ac_cv_path_CONSOLE_HELPER=%_bindir/consolehelper
%configure \
		--with-sysconfsubdir=X11/gdm \
		--enable-console-helper \
		--enable-authentication-scheme=%authentication_scheme \
		--with-pam-prefix=%_sysconfdir \
		%{?_with_consolekit:--with-console-kit=yes} \
		%{subst_with selinux} \
		%{?_with_libaudit:--with-libaudit=yes} \
		--enable-secureremote=yes \
		--disable-scrollkeeper \
		%{subst_enable static} \
		--disable-dependency-tracking

%make_build
gzip -9nf ChangeLog

%install
mkdir -p %buildroot%_datadir/gdm/autostart/LoginWindow

%make DESTDIR=%buildroot logdir=/var/log/gdm install

mkdir -p %buildroot%_sysconfdir/X11/sessions
install -m644 %SOURCE1 %buildroot%_datadir/pixmaps/gdm-screen.png

ln -s consolehelper %buildroot%_bindir/gdmsetup

# fix custom.conf
subst 's,/usr/lib/gdm,%_libexecdir,g' \
       %buildroot%_sysconfdir/X11/%base_name/custom.conf

# control gdm/xdmcp
install -pDm755 %SOURCE3 %buildroot%_controldir/gdm_xdmcp

# install gdm-termok-command
install -pDm755 %SOURCE4 %buildroot%_sbindir/gdm-termok-command

%find_lang %base_name
%find_lang --output=%base_name-help.lang --without-mo --with-gnome %base_name

%pre
%pre_control gdm_xdmcp

%post
%post_control -s disabled gdm_xdmcp

%files -f %base_name.lang
%_bindir/*
%_sbindir/*
%_libexecdir/*
%_libdir/gtk-2.0/modules/lib*.so
%_datadir/%base_name
%_pixmapsdir/*
%_datadir/icons/*/*/*/*.*
# gnome.desktop xsession moved to gnome-session
#%_datadir/xsessions
%_datadir/xsessions/ssh.desktop

%dir %_sysconfdir/X11/sessions

%config %_controldir/gdm_xdmcp
%config %_sysconfdir/pam.d/*
%config(noreplace) %_sysconfdir/X11/%base_name
%config(noreplace) %_sysconfdir/security/console.apps/*

%_man1dir/*
%doc AUTHORS ChangeLog* NEWS README TODO

%dir %_var/log/gdm
%attr(750, gdm, gdm) %dir %_localstatedir/gdm

%files help -f %base_name-help.lang

%exclude %_libdir/gtk-2.0/modules/lib*.la

%changelog
