%define ver_major 3.8
%def_enable python
%define gedit_pluginsdir %_libdir/gedit/plugins
%add_python3_compile_include %gedit_pluginsdir

Name: gedit-plugins
Version: %ver_major.3
Release: alt1

Summary: Plugins for GEdit
License: GPL
Group: Editors
Url: http://gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Requires: gedit >= %ver_major
Requires: libpeas-python3-loader

AutoReqProv: nopython
%define __python %nil

# From configure.in
%define glib_ver 2.31.0
%define gtk_ver 3.3.7
%define gtksourceview_ver 3.3.0
%define gedit_ver 3.8.0
%define peas_ver 1.7.0

BuildPreReq: rpm-build-gnome >= 0.6

# From configure.in
BuildPreReq: intltool >= 0.35.0
BuildPreReq: gnome-doc-utils >= 0.3.2
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgtksourceview3-devel >= %gtksourceview_ver
BuildPreReq: gedit-devel >= %gedit_ver
BuildPreReq: libpeas-devel >= %peas_ver
# for git plugin
BuildRequires: libgit2-glib-devel
# for Charmap plugin
BuildPreReq: libgucharmap-devel >= 3.0.0
%{?_enable_python:BuildRequires: rpm-build-python3 python3-devel python3-module-pygobject3-devel}
BuildRequires: libSM-devel libxml2-devel python3-module-dbus-devel libvte3-devel

%description
gEdit is a small but powerful text editor designed expressly for GNOME.

It includes such features as split-screen mode, a plugin API, which
allows gEdit to be extended to support many features while remaining
small at its core, multiple document editing through the use of a
'tabbed' notebook and many more functions.

This package contains various plugins for gEdit, including Charmap, Terminal, and others.

%prep
%setup -q

%build
%configure \
    --disable-static \
    --disable-schemas-compile \

%make_build

%install
%make_install install DESTDIR=%buildroot

%find_lang --with-gnome %name

%files -f %name.lang
%dir %_datadir/gedit/plugins
%_datadir/gedit/plugins/*
%gedit_pluginsdir/*
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.drawspaces.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.gedit.plugins.terminal.gschema.xml

%exclude %gedit_pluginsdir/*.la

%changelog
