Name: git
Version: 2.6.5
Release: alt2.M70P.1

Summary: Git core and tools
License: GPLv2
Group: Development/Other
Url: http://git-scm.com/

# git://git.altlinux.org/gears/g/git.git
Source: %name-%version-%release.tar

%def_enable curl
%def_enable expat
%def_with arch
%def_with cvs
%def_with email
%def_with tk
%def_with gui
%def_with doc
%def_with emacs
%def_with gitweb
%def_without python
%def_with svn

%define _libexecdir /usr/libexec
%define gitexecdir %_libexecdir/git-core
%define pkgdocdir %_docdir/%name

Requires: %name-core = %version-%release, %name-server = %version-%release
%{!?_without_arch:Requires: %name-arch = %version-%release}
%{!?_without_cvs:Requires: %name-cvs = %version-%release}
%{!?_without_email:Requires: %name-email = %version-%release}
%{!?_without_svn:Requires: %name-svn = %version-%release}
%{!?_without_tk:Requires: gitk = %version-%release}
%{!?_without_gui:Requires: %name-gui = %version-%release}
%{!?_without_doc:Requires: %name-doc = %version-%release}
%{!?_without_emacs:Requires: emacs-%name = %version-%release}
%{!?_without_gitweb:Requires: gitweb = %version-%release}

BuildRequires: hardlink, libssl-devel, perl-devel, perl(Error.pm), zlib-devel >= 0:1.2
%{!?_without_python:BuildRequires: python-modules-encodings >= 0:2.4}
%{!?_without_cvs:BuildRequires: cvs perl(DBI.pm)}
%{!?_disable_curl:BuildRequires: libcurl-devel}
%{!?_disable_expat:BuildRequires: libexpat-devel}
%{!?_without_email:BuildRequires: perl(Error.pm) perl(Net/SMTP/SSL.pm) perl(Term/ReadLine.pm)}
%{!?_without_svn:BuildRequires: perl(Encode.pm) perl(Memoize.pm) perl(SVN/Core.pm) perl(Term/ReadKey.pm) perl(YAML/Any.pm) subversion subversion-server-common}
%{!?_without_doc:BuildRequires: asciidoc > 0:6.0.3, xmlto}
%{?!_without_emacs:BuildRequires: emacs-devel emacs-nox}
%{?!_without_gitweb:BuildRequires: perl(charnames.pm) perl(CGI.pm) perl(Encode.pm)}
%{?!_without_check:%{?!_disable_check:BuildRequires: cvsps gnupg perl(HTTP/Date.pm) perl(Term/ANSIColor.pm) perl(DBD/SQLite.pm) perl(Encode/JP.pm) unzip}}

%description
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

%package core
Summary: Git core tools
Group: Development/Other
Requires: diffstat less openssh-clients rsync
# due to git commit --fast.
Provides: git-commit-fast

%description core
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains core set of Git tools with minimal dependencies.

%package server
Summary: Simple TCP git server for git repositories
Group: System/Servers
Requires: %name-core = %version-%release
PreReq: shadow-utils

%description server
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains git server that normally listens on TCP port 9418.
It waits for a connection, and will just execute "git-upload-pack"
when it gets one.  It is ideally suited for read-only updates, i.e.,
pulling from git repositories.

%package arch
Summary: Git tools for importing Arch repositories
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %version-%release, tla

%description arch
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for importing Arch repositories.

%package cvs
Summary: Git tools for importing CVS repositories
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %version-%release, perl-Git = %version-%release, cvs, cvsps

%description cvs
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for importing CVS repositories.

%package -n perl-Git
Summary: Perl interface to Git
Group: Development/Perl
BuildArch: noarch
Requires: %name-core = %version-%release

%description -n perl-Git
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Perl interface to Git.

%package email
Summary: Git tools for sending email
Group: Development/Other
BuildArch: noarch
Requires: perl-Git = %version-%release
# Workaround for ALT#23407.
Requires: perl(MIME/Base64.pm) perl(Authen/SASL.pm)

%description email
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for sending email.

%package svn
Summary: Git tools for importing Subversion repositories
Group: Development/Other
Requires: %name-core = %version-%release, perl-Git = %version-%release, subversion

%description svn
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git tools for importing Subversion repositories.

%package -n gitk
Summary: Git revision tree visualiser ('gitk')
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %version-%release, tk >= 8.4

%description -n gitk
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git revision tree visualiser ('gitk').

%package gui
Summary: Git GUI tool
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %version-%release, tk >= 8.4

%description gui
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git GUI tool.

%package -n gitweb
Summary: Git web interface
Group: Development/Other
BuildArch: noarch
Requires: %name-core = %version-%release
Requires: perl(charnames.pm)

%description -n gitweb
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains simple web interface to track changes in Git
repositories.

%package -n libgit-devel
Summary: Git develpoment library and header files
Group: Development/C

%description -n libgit-devel
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains libgit.a develpoment library and accompanying
header files.

%package doc
Summary: Git documentation
Group: Development/Documentation
BuildArch: noarch
Provides: %name-docs = %version-%release
Obsoletes: %name-docs

%description doc
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains the Git documentation in text and HTML formats.

%package contrib
Summary: Git contrib files
Group: Development/Other
BuildArch: noarch
AutoReq: no
Requires: %name-core = %version-%release

%description contrib
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Git contributed software.

%package -n emacs-%name
Summary: Emacs modes for Git
Group: Development/Other
BuildArch: noarch

%description -n emacs-%name
Git is a fast, scalable, distributed revision control system with an
unusually rich command set that provides both high-level operations
and full access to internals.

This package contains Emacs modes for Git.

%prep
%setup -n %name-%version-%release
cat >config.mak <<'EOF'
V = 1
CFLAGS = %optflags
NO_GETTEXT = 1
BLK_SHA1 = 1
GNU_ROFF = 1
ETC_GITCONFIG = /etc/gitconfig
prefix = %_prefix
libdir = %_libdir
mandir = %_mandir
htmldir = %pkgdocdir
%{?_disable_curl:NO_CURL = 1}
%{?_disable_expat:NO_EXPAT = 1}
%{?_without_python:NO_PYTHON = 1}
%{?_without_python:SCRIPT_PYTHON_INS = }
EOF

%build
touch git-gui/credits
%make_build -C Documentation doc.dep
%make_build all %{!?_without_doc:man html}
pushd perl
rm Makefile
ln -s perl.mak Makefile
%perl_vendor_build
popd
%{!?_without_emacs:%make_build -C contrib/emacs EMACS="%__emacs --eval \"(provide 'message)\""}

%check
%make_build -k test

%install
%makeinstall_std \
	install-lib \
	%{!?_without_doc:install-man install-html}

mkdir -p %buildroot%_includedir/git
find -name \*.d -print0 |
	xargs -0 sed -n 's/^\([^:[:space:]]*\.h\)[[:space:]]*:.*/\1/p' -- |
	sort -u |
	xargs realpath -e --relative-to=. -- |
	sort -u > headers.list
tr / '\n' < headers.list |
	grep -Fv .h |
	sort -u |
	xargs -i ln -s . %buildroot%_includedir/git/'{}'
xargs install -pm644 -t %buildroot%_includedir/git -- < headers.list
find %buildroot%_includedir -type f -print0 |
	xargs -0 grep -lZ 'include.*SHA1_HEADER' -- |
	xargs -0 sed -i '/include/ s/SHA1_HEADER/"sha1.h"/' --

chmod a-x %buildroot%gitexecdir/git-sh-setup
install -pDm644 contrib/completion/git-completion.bash \
	%buildroot/etc/bash_completion.d/git
# Generate shell functions provides list.
(
	echo '# shell functions provides list'
	sed -n 's/^\([A-Za-z][A-Za-z_0-9]*\)[[:space:]]*().*/\1/pg' \
		%buildroot%gitexecdir/git-sh-setup |
		LC_COLLATE=C sort -u
) > %buildroot%gitexecdir/.provides.sh

pushd perl
%perl_vendor_install
find %buildroot -type f -name perllocal.pod -delete
popd

# git-server.
mkdir -p %buildroot%_sbindir
mv %buildroot%gitexecdir/git-daemon %buildroot%_sbindir/
install -pD -m640 git.xinetd \
	%buildroot%_sysconfdir/xinetd.d/git

%if_with emacs
%makeinstall_std -C contrib/emacs emacsdir=%_emacslispdir
install -pm644 contrib/emacs/*.el %buildroot%_emacslispdir/
mkdir -p %buildroot%_emacs_sitestart_dir
cat >%buildroot%_emacs_sitestart_dir/git.el <<__EOF
; site-start script for Emacs, initializes git and vc-git
; Evgenii Terechkov, Octember 2006

(require 'git)
(add-to-list 'vc-handled-backends 'GIT)
__EOF
%endif #emacs

# Fix manpages.
find %buildroot%_mandir -type f -print0 |
	xargs -r0 grep -lZ '^.\+\.sp$' -- |
	xargs -r0 sed -i 's/^\(.\+\)\(\.sp\)$/\1\n\2/' --

# Install docs and contrib.
mkdir -p %buildroot%pkgdocdir/
install -pm644 Documentation/SubmittingPatches %buildroot%pkgdocdir/
cp -a contrib %buildroot%_datadir/git-core/
rm -r %buildroot%_datadir/git-core/contrib/completion
rm -r %buildroot%_datadir/git-core/contrib/emacs

# Remove unpackaged files.
%{?_without_arch:rm %buildroot%gitexecdir/git-archimport}
%{?_without_email:rm %buildroot%gitexecdir/git-*email*}
%{?_without_svn:rm %buildroot%gitexecdir/git-*svn*}

# Relocate hooks, convert template hooks to symlinks.
pushd %buildroot%_datadir/git-core/templates/hooks
	mkdir ../../hooks
	for f in *.sample; do
		mv $f ../../hooks/${f%%.sample}
		ln -s %_datadir/git-core/hooks/${f%%.sample} $f
	done
popd

# Avoid compressing templates.
%set_compress_topdir %_mandir

# Hardlink identical files together.
%define __spec_install_custom_post  hardlink -vc %buildroot

%pre server
/usr/sbin/groupadd -r -f _gitd
/usr/sbin/useradd -r -g _gitd -d /dev/null -s /dev/null -c 'The git server' -n _gitd >/dev/null 2>&1 ||:

%files

%files core
%config /etc/bash_completion.d/git
%_bindir/*
%exclude %_bindir/git-cvs*
%gitexecdir/
%exclude %gitexecdir/git-cvs*
%exclude %gitexecdir/git-gui*
%exclude %gitexecdir/git-citool
%exclude %gitexecdir/git-add--interactive
%exclude %gitexecdir/git-difftool
%exclude %gitexecdir/git-relink
%exclude %_bindir/gitk
%{!?_without_arch:%exclude %gitexecdir/git-archimport}
%{!?_without_email:%exclude %gitexecdir/git-*email*}
%{!?_without_svn:%exclude %gitexecdir/*svn*}
%_datadir/git-core/
%exclude %_datadir/git-core/contrib/
%if_with doc
%_mandir/man?/*
%exclude %_man1dir/git-daemon.*
%exclude %_man1dir/git-svn*.1*
%exclude %_man1dir/git-cvs*.1*
%exclude %_man1dir/git-archimport.1*
%exclude %_man1dir/git-*email*.1*
%exclude %_man1dir/git-difftool.*
%exclude %_man1dir/git-relink.*
%exclude %_man1dir/gitk*.1*
%exclude %_mandir/man?/gitweb.*
%endif #doc

%files server
%_sbindir/git-daemon
%if_with doc
%_man1dir/git-daemon.*
%endif #doc
%attr(640,root,wheel) %config(noreplace) %_sysconfdir/xinetd.d/git

%if_with arch
%files arch
%gitexecdir/git-archimport
%if_with doc
%_man1dir/git-archimport.1*
%endif #doc
%endif #arch

%if_with cvs
%files cvs
%_bindir/*cvs*
%gitexecdir/*cvs*
%if_with doc
%_man1dir/git-cvs*.1*
%endif #doc
%endif #cvs

%files -n perl-Git
%gitexecdir/git-add--interactive
%gitexecdir/git-difftool
%gitexecdir/git-relink
%_man1dir/git-difftool.*
%_man1dir/git-relink.*
%perl_vendor_privlib/Git/
%perl_vendor_privlib/Git.pm
%exclude %perl_vendor_privlib/Git/SVN*

%if_with email
%files email
%gitexecdir/*email*
%if_with doc
%_man1dir/git-*email*.1*
%endif #doc
%endif #email

%if_with svn
%files svn
%gitexecdir/*svn*
%if_with doc
%_man1dir/git-svn*.1*
%endif #doc
%perl_vendor_privlib/Git/SVN*
%endif #svn

%if_with tk
%files -n gitk
%_bindir/gitk
%_datadir/gitk/
%if_with doc
%_man1dir/gitk.1*
%endif #doc
%endif #tk

%if_with gui
%files gui
%gitexecdir/git-gui*
%gitexecdir/git-citool
%_datadir/git-gui/
%if_with doc
# Not Yet...
# %_man1dir/git-gui.1*
# %_man1dir/git-citool.1*
%endif #doc
%endif #gui

%if_with gitweb
%files -n gitweb
%_datadir/gitweb/
%if_with doc
%_mandir/man?/gitweb.*
%endif #doc
%endif #gitweb

%files -n libgit-devel
%_libdir/lib*
%_includedir/*

%files doc
%pkgdocdir/

%files contrib
%dir %_datadir/git-core/
%_datadir/git-core/contrib/

%if_with emacs
%files -n emacs-%name
%_emacs_sitestart_dir/*
%_emacslispdir/*
%endif #emacs

%changelog
