BuildRequires: desktop-file-utils
%def_enable nautilus

Name: gksu
Version: 2.0.2
Release: alt5

Summary: A Gtk+-based 'su' wrapper
License: %gpl2plus
Group: Graphical desktop/GNOME
Url: http://www.nongnu.org/%name/

Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Source: http://people.debian.org/~kov/%name/%name-%version.tar.gz
Source1: %name-l10n.tar
Patch2: nautilus-%name-2.0.2-fix-handler-invocation.patch
Patch3: 01_desktop_in.patch
Patch4: 02_format_security.patch
Patch5: 50_always_ask.patch
Patch6: 99_intltool.patch
Patch7: %name-only-glib.h-includes.patch

# From configure.ac
%define libgksu_ver 1.9.8
%define gtk_ver 2.4.0

BuildPreReq: rpm-build-licenses rpm-build-gnome

# From configure.ac
BuildPreReq: libgksu-devel >= %libgksu_ver
BuildPreReq: libgtk+2-devel >= %gtk_ver
BuildPreReq: gettext-tools intltool
BuildPreReq: gtk-doc >= 1.0
%{?_enable_nautilus:BuildPreReq: libnautilus-devel gnome-vfs-devel}

BuildRequires: perl-XML-Parser
Requires: xvt

%description
GKSu is a stack of libraries and an application that provide a Gtk+
frontend to su and sudo. It supports login shells and preserving
environment when acting as a su frontend. It is useful to menu items or
other graphical programs that need to ask a user's password to run another
program as another user.

%if_enabled nautilus
%package -n nautilus-%name
Summary: A plugin for Nautilus to open files as a privileged user
Group: Graphical desktop/GNOME

%description -n nautilus-%name
This package contains a plugin for Nautilus that integrates su and sudo
into the file manager by means of GKSu software.
%endif

%prep
%setup -q
%patch7 -p2
%patch2 -p0 -b .fix-handler-invocation
%patch3 -p1 
%patch4 -p1 
%patch5 -p1 
%patch6 -p1 
tar xf %SOURCE1

%build
export CPPFLAGS="$CPPFLAGS `pkg-config --cflags-only-I gnome-vfs-2.0`"
export LDFLAGS="$LDFLAGS `pkg-config --libs gnome-vfs-2.0`"
%configure \
    %{?_enable_nautilus:--enable-nautilus-extension} \
    --disable-static \
    --enable-gtk-doc

%make_build nautilus_extensiondir=%nautilus_extdir
make -C po update-po

%install
%makeinstall_std nautilus_extensiondir=%nautilus_extdir

# Copy the icon to the standard location
mkdir -p %buildroot%_liconsdir
cp -a %buildroot%_pixmapsdir/%name-*.png %buildroot%_liconsdir/

%find_lang %name
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Utility \
	--add-category=System \
	%buildroot%_desktopdir/gksu.desktop

%files -f %name.lang
%_bindir/gksu
%_bindir/gksudo
%dir %_datadir/%name
%_datadir/%name/gksu-migrate-conf.sh
%_pixmapsdir/%name-*.png
%_liconsdir/%name-*.png
%_desktopdir/%name.desktop
%_man1dir/*.1.gz

%files -n nautilus-gksu
%nautilus_extdir/libnautilus-%name.so
%exclude %nautilus_extdir/*.la

%changelog
