Name: glib
Version: 1.2.10
Release: alt18

Summary: A library of handy utility functions
License: LGPLv2.1+
Group: System/Libraries
Url: http://www.gtk.org/

# ftp://ftp.gtk.org/pub/gtk/v1.2/glib-%version.tar.bz2
Source: glib-%version.tar
Patch1: glib-1.2.8-alt-texinfo.patch
Patch2: glib-1.2.10-rh-isowarning.patch
Patch3: glib-1.2.10-rh-m4.patch
Patch4: glib-1.2.10-rh-gcc34.patch
Patch5: glib-1.2.10-alt-linkage.patch

%def_enable static
%set_automake_version 1.4
%set_autoconf_version 2.13
%set_libtool_version 1.5

%package devel
Summary: Development environment for the glib library
Group: Development/C
Requires: %name = %version-%release

%package devel-static
Summary: Static libraries for development with glib
Group: Development/C
Requires: %name-devel = %version-%release

%description
Glib is a handy library of utility functions.  This C library is designed
to solve some portability problems and provide other useful functionality
which most programs require.

%description devel
Include files for the glib support library.  GLIB includes generally
useful data structures.

%description devel-static
Static libraries for development statically linked glib-based programs.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
find -type f -name \*.orig -delete

%build
%add_optflags -fno-strict-aliasing
libtoolize --copy --force
aclocal
# new gettext introduce new m4 macros which depend on fresh autoconf
# and automake; hopefully glib doesn't use gettext and its m4 macros.
%__subst -p 's,^AC_PREREQ(\[\?2\.5[0-9]\]\?),AC_PREREQ(2.13),' *.m4
autoheader
automake
autoconf
sed -i 's,/lib/,/%_lib/,g; s,/lib ,/%_lib ,g' ltconfig

%configure %{subst_enable static}
%make_build

%install
mkdir -p %buildroot/%_lib
%makeinstall

# Relocate shared libraries from %_libdir/ to /%_lib/.
for f in %buildroot%_libdir/*.so; do
	t=$(readlink -v "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -pm644 AUTHORS NEWS README %buildroot%docdir/
bzip2 -9 %buildroot%docdir/NEWS

%files
/%_lib/*
%dir %docdir
%docdir/[ABD-Z]*

%files devel
%_bindir/*
%_libdir/*.so
%_libdir/glib
%_libdir/pkgconfig/*
%_includedir/*
%_datadir/aclocal/*
%_mandir/man?/*
%_infodir/*.info*

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
