%define ver_major 2.36

Name: glib-networking
Version: %ver_major.2
Release: alt1

Summary: Networking support for GIO
Group: System/Libraries
License: LGPLv2+
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/sources/gnome/%name/%ver_major/%name-%version.tar.xz

Requires: ca-certificates gsettings-desktop-schemas >= 3.2.0

%define glib_ver 2.35.3
%define gnutls_ver 2.12.8

BuildRequires: intltool libgio-devel >= %glib_ver libproxy-devel
BuildRequires: libgnutls-devel >= %gnutls_ver libgcrypt-devel
BuildRequires: libp11-kit-devel ca-certificates gsettings-desktop-schemas-devel

%description
This package contains modules that extend the networking support in GIO.
In particular, it contains a libproxy-based GProxyResolver implementation
and a gnutls-based GTlsConnection implementation.

%define _libexecdir %_prefix/libexec

%prep
%setup -q

%build
%configure \
	--disable-static \
	--with-libproxy \
	--with-ca-certificates=%_datadir/ca-certificates/ca-bundle.crt

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name

%check
#%%make check

%files -f %name.lang
%_libexecdir/glib-pacrunner
%_libdir/gio/modules/libgiolibproxy.so
%_libdir/gio/modules/libgiognutls.so
%_libdir/gio/modules/libgiognomeproxy.so
%_datadir/dbus-1/services/org.gtk.GLib.PACRunner.service
%doc NEWS README

%exclude %_libdir/gio/modules/*.la

%changelog
