%def_disable snapshot

%define ver_major 2.36
%define pcre_ver 8.11
%def_without sys_pcre
%def_enable selinux
%def_disable fam

%if_enabled snapshot
%def_enable gtk_doc
%else
%def_disable gtk_doc
%endif

Name: glib2
Version: %ver_major.4
Release: alt0.M70P.2

Summary: A library of handy utility functions
License: %lgpl2plus
Group: System/Libraries
Url: ftp://ftp.gnome.org

%if_enabled snapshot
Source: glib-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/glib/%ver_major/glib-%version.tar.xz
%endif

Source1: glib-compat.map
Source2: glib-compat.lds
Source3: gobject-compat.map
Source4: gobject-compat.lds
Source5: gio-compat.map
Source6: gio-compat.lds

Source10: glib2.sh
Source11: glib2.csh

Patch: glib-2.35.9-alt-compat-version-script.patch
# stop spam about deprecated paths in schemas
Patch1: glib-2.36.1-alt-deprecated_paths-nowarning.patch
Patch2: glib-2.36-add-xvt.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=707298
Patch3: glib-2.38-bgo-707298.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=706254
Patch10: glib-2.8.2-up-44edc3829d6db3fabe22d837eaaf2638003516c9.patch

%def_with locales
%if_with locales
Requires: %name-locales = %version
%endif

Provides: lib%name = %version
Obsoletes: lib%name < %version

Provides: %name-core = %version
Obsoletes: %name-core < %version

# use python3
#AutoReqProv: nopython
#%define __python %nil
#%%add_python3_lib_path %_datadir/glib-2.0/codegen
%add_python_lib_path %_datadir/glib-2.0/codegen

%if_with sys_pcre
BuildPreReq: libpcre-devel >= %pcre_ver
Requires: pcre-config(utf8) pcre-config(unicode-properties)
BuildPreReq: pcre-config(utf8) pcre-config(unicode-properties)
%endif

BuildRequires(pre): rpm-build-licenses
BuildPreReq: gtk-doc >= 1.8

BuildRequires: gtk-doc indent glibc-kernheaders libdbus-devel libpcre-devel
BuildRequires: libffi-devel zlib-devel libelf-devel
BuildRequires: rpm-build-python python-devel
#BuildRequires: rpm-build-python3 python3-devel
%{?_enable_selinux:BuildRequires: libselinux-devel}
%{?_enable_fam:BuildRequires: libgamin-devel}

# for check
BuildRequires: /proc dbus-tools-gui desktop-file-utils

%description
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

%package locales
Summary: Glib internationalization
Group: System/Internationalization
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description locales
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package provides internationalization support for Glib.

%package devel
Summary: Development files and tools for GLib
Group: Development/C
Requires: %name = %version-%release
Requires: rpm-build-gir >= 0.5
Provides: lib%name-devel = %version
Obsoletes: lib%name-devel < %version

%description devel
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package provides header files and development tools for GLIB.

%package devel-static
Summary: Static version of GLib libraries
Group: Development/C
Requires: %name-devel = %version-%release
Provides: lib%name-devel-static = %version
Obsoletes: lib%name-devel-static < %version

%description devel-static
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package provides GLIB static libraries.

%package doc
Summary: Documentation for GLib
Group: Development/Documentation
Provides: %name-devel-doc = %version
Obsoletes: %name-devel-doc < %version
Conflicts: %name < %version, %name > %version
BuildArch: noarch

%description doc
GLib is the low-level core library that forms the basis for projects
such as GTK+ and GNOME. It provides data structure handling for C,
portability wrappers, and interfaces for such runtime functionality as
an event loop, threads, dynamic loading, and an object system.

This package contains documentation for GLib.

%package -n libgio
Summary: GIO input/output framework
Group: System/Libraries
Requires: %name = %version-%release
Requires: gsettings-desktop-schemas
Requires: shared-mime-info >= 0.80

%description -n libgio
GIO is a VFS API, designed to replace GnomeVFS. This GIO implementation is
a part of Glib project; it has support for local filesystems, and
a separate GVFS project contains various backend implementations (CIFS,
FTP, SFTP etc.).

%package -n libgio-devel
Summary: GIO input/output framework
Group: Development/C
Requires: libgio = %version-%release
Requires: %name-devel = %version-%release

%description -n libgio-devel
GIO is a VFS API, designed to replace GnomeVFS. This GIO implementation is
a part of Glib project; it has support for local filesystems, and
a separate GVFS project contains various backend implementations (CIFS,
FTP, SFTP etc.).

This package contains files necessary for development with GIO.

%package -n libgio-doc
Summary: GIO documentation
Group: Development/Documentation
# due to HTML links
Requires: %name-doc = %version
BuildArch: noarch

%description -n libgio-doc
GIO is a VFS API, designed to replace GnomeVFS. This GIO implementation is
a part of Glib project; it has support for local filesystems, and
a separate GVFS project contains various backend implementations (CIFS,
FTP, SFTP etc.).

This package contains documentation for GIO.

%if 0
%package gdb
Group: System/Libraries
%description gdb
%endif

%prep
%setup -n glib-%version
%patch
%patch1
%patch2 -p2
%patch3 -p1
%patch10 -p1

%if_with sys_pcre
rm glib/pcre/*.[ch]
%endif

install -p -m644 %_sourcedir/glib-compat.map glib/compat.map
install -p -m644 %_sourcedir/glib-compat.lds glib/compat.lds
install -p -m644 %_sourcedir/gobject-compat.map gobject/compat.map
install -p -m644 %_sourcedir/gobject-compat.lds gobject/compat.lds
install -p -m644 %_sourcedir/gio-compat.map gio/compat.map
install -p -m644 %_sourcedir/gio-compat.lds gio/compat.lds

# abicheck always ok
subst '/exit 1/d' check-abis.sh

%build
%if_enabled snapshot
NOCONFIGURE=1 ./autogen.sh
%else
%autoreconf
%endif

%configure \
    --enable-static \
    %{subst_enable selinux} \
    --enable-xattr \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    --enable-included-printf=no \
    %{?_with_sys_pcre:--with-pcre=system} \
    %{subst_enable fam}

%make_build

%install
%make_install install DESTDIR=%buildroot

# Relocate libgilb-2.0.so.0 to /%_lib.
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libglib-2.0.so.0* %buildroot/%_lib
rm %buildroot%_libdir/libglib-2.0.so
ln -s ../../%_lib/libglib-2.0.so.0 %buildroot%_libdir/libglib-2.0.so

install -pD -m755 %_sourcedir/glib2.sh %buildroot%_sysconfdir/profile.d/glib2.sh
install -pD -m755 %_sourcedir/glib2.csh %buildroot%_sysconfdir/profile.d/glib2.csh

chmod +x %buildroot%_bindir/gtester-report

# GIO modules cache
touch %buildroot%_libdir/gio/modules/giomodule.cache
# filetrigger that updates GIO modules cache
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%_libdir/gio/modules/
grep -qs '^'\$dir'' && /usr/bin/gio-querymodules \$dir ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gio.filetrigger

# filetrigger that compiles all the GSettings XML schema files under %_datadir/glib-2.0/schemas
cat <<EOF > filetrigger
#!/bin/sh -e

dir=%_datadir/glib-2.0/schemas
grep -qs '^'\$dir'' && /usr/bin/glib-compile-schemas --allow-any-name \$dir ||:
EOF

install -pD -m 755 filetrigger %buildroot%_rpmlibdir/gsettings.filetrigger


%find_lang glib20
%set_verify_elf_method strict

%check
# g_mapped_file_new fails on /dev/null in hasher
# GLib:ERROR:mappedfile.c:52:test_device: assertion failed (error == (g-file-error-quark, 17)): Failed to map /dev/null' /dev/null': mmap() failed: No such device (g-file-error-quark, 7)
#%make check

%files
/%_lib/libglib-2.0.so.0*
%_libdir/libgobject-2.0.so.0*
%_libdir/libgmodule-2.0.so.0*
%_libdir/libgthread-2.0.so.0*
%config(noreplace) %_sysconfdir/profile.d/*
%doc AUTHORS NEWS README

%files locales -f glib20.lang

%files devel
%_bindir/glib-genmarshal
%_bindir/glib-gettextize
%_bindir/glib-mkenums
%_bindir/gobject*
%_bindir/gtester*
%dir %_includedir/glib-2.0
%_includedir/glib-2.0/glib*
%_includedir/glib-2.0/gobject*
%_includedir/glib-2.0/gmodule*
%dir %_libdir/glib-2.0
%dir %_libdir/glib-2.0/include
%_libdir/glib-2.0/include/*.h
%_libdir/libglib-2.0.so
%_libdir/libgmodule-2.0.so
%_libdir/libgobject-2.0.so
%_libdir/libgthread-2.0.so
%_pkgconfigdir/glib-2.0.pc
%_pkgconfigdir/gmodule*-2.0.pc
%_pkgconfigdir/gobject-2.0.pc
%_pkgconfigdir/gthread-2.0.pc
%_datadir/aclocal/glib*.m4
%_datadir/aclocal/gsettings.m4
%dir %_datadir/glib-2.0
%_datadir/glib-2.0/gettext/
%_datadir/glib-2.0/codegen/
%_man1dir/glib-genmarshal.*
%_man1dir/glib-gettextize.*
%_man1dir/glib-mkenums.*
%_man1dir/gobject*
%_man1dir/gtester*

%files devel-static
%_libdir/libglib-2.0.a
%_libdir/libgobject-2.0.a
%_libdir/libgthread-2.0.a
# gmodule and gio use dynamic loading
%exclude %_libdir/libgmodule-2.0.a
%exclude %_libdir/libgio-2.0.a
%if_enabled fam
%exclude %_libdir/gio/modules/libgiofam.a
%exclude %_libdir/gio/modules/libgiofam.la
%endif

%files doc
%doc %_datadir/gtk-doc/html/glib
%doc %_datadir/gtk-doc/html/gobject

%files -n libgio
%_bindir/gio-querymodules
%_bindir/gsettings
%_bindir/glib-compile-schemas
%_bindir/gresource
%_bindir/glib-compile-resources
%_bindir/gdbus
%_libdir/libgio-2.0.so.*
%dir %_libdir/gio
%dir %_libdir/gio/modules
%{?_enable_fam:%_libdir/gio/modules/libgiofam.so}
%_libdir/gio/modules/giomodule.cache
%_rpmlibdir/gio.filetrigger
%_rpmlibdir/gsettings.filetrigger
%_datadir/glib-2.0/schemas/
%_man1dir/gsettings.*
%_man1dir/glib-compile-schemas.*
%_man1dir/gresource.*
%_man1dir/glib-compile-resources.1*
%_man1dir/gdbus.*
%_man1dir/gio-querymodules.*
%_datadir/bash-completion/completions/gresource

%files -n libgio-devel
%_bindir/gdbus-codegen
%dir %_includedir/glib-2.0
%dir %_includedir/glib-2.0/gio
%_includedir/glib-2.0/gio/*.h
%dir %_includedir/gio-unix-2.0
%dir %_includedir/gio-unix-2.0/gio
%_includedir/gio-unix-2.0/gio/*.h
%_libdir/libgio-2.0.so
%_pkgconfigdir/gio-2.0.pc
%_pkgconfigdir/gio-unix-2.0.pc
%_man1dir/gdbus-codegen.*

%files -n libgio-doc
%doc %_datadir/gtk-doc/html/gio

%exclude %_datadir/bash-completion/completions/gdbus
%exclude %_datadir/bash-completion/completions/gsettings
%exclude %_datadir/gdb/auto-load/%_libdir/libglib-2.0.so.0.*-gdb.py
%exclude %_datadir/gdb/auto-load/%_libdir/libgobject-2.0.so.0.*-gdb.py
%exclude %_datadir/glib-2.0/gdb/


%changelog
