%define stage 42-g779b491

%def_enable bdb
%def_enable ibverbs
%def_enable libglusterfsclient
%def_disable static

Summary: GNU Cluster File System
Name: glusterfs
Version: 2.0.9
Release: alt0.42.g779b491.1
License: GPLv3 or later
Group: System/Base
Packager: L.A. Kostis <lakostis@altlinux.ru>

%{?_enable_bdb:BuildRequires: db4-devel}
%{?_enable_libglusterfsclient:BuildRequires: libfuse-devel}
%{?_enable_ibverbs:BuildRequires: libibverbs-devel}

BuildRequires: libtool
BuildRequires: bison flex

# due recent incompatibility between releases :(
Requires: lib%name = %version-%release
%{?_enable_libglusterfsclient:Requires: libglusterfsclient = %version-%release}

Url: http://www.glusterfs.org
Source0: ftp://ftp.zresearch.com/pub/gluster/glusterfs/2.0/%name-%{version}-%{stage}.tar.gz
Source1: %{name}d.init
Source2: %{name}d

%description
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

%package -n lib%{name}
Summary: GlusterFS Libraries
Group: System/Libraries

%description -n lib%{name}
This package provides system libraries for GlusterFS.

%if_enabled libglusterfsclient
%package -n libglusterfsclient
Summary: FUSE based GlusterFS client
Group: System/Base
Requires: lib%name = %version-%release
Obsoletes: %name-client < 2.0.0
Provides: %name-client

%description -n libglusterfsclient
This package provides the FUSE based GlusterFS client.
%endif

%package devel
Summary: GlusterFS Development Libraries
Group: Development/C
Requires: %name = %version-%release

%description devel
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package provides the development libraries.

%package devel-static
Summary: GlusterFS Development Libraries
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package provides the static version of GlusterFS development libraries.

%prep
%setup

%build
%autoreconf
%configure \
	--localstatedir=%{_var} \
	%{subst_enable static} \
	%{subst_enable bdb} \
	%{subst_enable libglusterfsclient} \
	%{subst_enable ibverbs}
%make_build

%install
%__make install DESTDIR=%buildroot
%__mkdir_p %buildroot{%_sysconfdir/sysconfig,%_initrddir}
rm -rf %buildroot%_initrddir/*
find %buildroot%_libdir/%name -name *.la -exec rm -rf {} \;
%__install -m755 %SOURCE1 %buildroot%_initrddir/%{name}d
%__install -m644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/
%__mkdir_p %buildroot{%_includedir/%name,%buildroot%_logdir/%name}
touch %buildroot%_logdir/%name/exports.log
%__cp %_builddir/%name-%version/libglusterfs/src/*.h %buildroot%_includedir/glusterfs/
%__mkdir_p %buildroot%_docdir/%name-%version
%__cp -a AUTHORS COPYING NEWS %buildroot%_docdir/%name-%version/
%__cp -a extras/*.sh %buildroot%_docdir/%name-%version/
%__mv %buildroot%_docdir/%name/examples %buildroot%_docdir/%name-%version/

%files
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/%{name}d.vol.sample
%config(noreplace) %_sysconfdir/sysconfig/%{name}d
%_initrddir/*
%_sbindir/%{name}d
%if_disabled libglusterfsclient
%config %_sysconfdir/%name/%name.vol.sample
%dir %_logdir/%name
%_sbindir/%{name}
%_man8dir/%{name}*
%endif
%_bindir/%{name}-volgen
%dir %_datadir/%{name}
%_datadir/%{name}
%ghost %_logdir/%name/exports.log
%dir %_docdir/%name-%version
%_docdir/%name-%version

%post
%post_service %{name}d

%preun
%preun_service %{name}d

%files -n libglusterfs
%dir %_libdir/%name
%_libdir/%name
%_libdir/lib*.so.*

%if_enabled libglusterfsclient
%files -n libglusterfsclient
%config %_sysconfdir/%name/%name.vol.sample
%_sbindir/%{name}
/sbin/mount.glusterfs
%dir %_logdir/%name
%_man8dir/*%{name}*
%endif

%files devel
%_libdir/*.so
%dir %_includedir/glusterfs
%_includedir/glusterfs/*
%exclude %_includedir/glusterfs/y.tab.h
%if_enabled libglusterfsclient
%_includedir/libglusterfsclient.h
%endif

%if_enabled static
%files devel-static
%_libdir/*.a
%endif

%changelog
