%define oname glusterfs
%define major 3.7
# if you wish to compile an rpm without rdma support, compile like this...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without rdma
%{?_without_rdma:%global _without_rdma --disable-ibverbs}

# if you wish to compile an rpm without epoll...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without epoll
%{?_without_epoll:%global _without_epoll --disable-epoll}

# if you wish to compile an rpm with fusermount...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --with fusermount
%{?_with_fusermount:%global _with_fusermount --enable-fusermount}

# if you wish to compile an rpm without geo-replication support, compile like this...
# rpmbuild -ta @PACKAGE_NAME@-@PACKAGE_VERSION@.tar.gz --without georeplication
%{?_without_georeplication:%global _without_georeplication --disable-geo-replication}

Summary: Cluster File System
Name: glusterfs3
Version: %major.0
Release: alt2.M70P.1
License: GPLv2/LGPLv3
Group: System/Base
Url: http://www.gluster.org/

Source0: %name-%version.tar
Source1: glusterd.sysconfig
Source2: %name.watch
Source3: umount.glusterfs
Source4: glusterfs-fuse.logrotate
Source5: glusterd.logrotate
Source6: glusterfsd.logrotate

Source7: glusterd.init


Patch0: %name-%version-%release.patch

%define _init_install() install -D -p -m 0755 %1 %buildroot%_initdir/%2 ;
%define _init_file1     %_initdir/glusterd
#%define _init_file2     %_initdir/glusterfsd

# Automatically added by buildreq on Mon Nov 19 2012
BuildRequires: flex glibc-devel-static libibverbs-devel libreadline-devel libssl-devel libxml2-devel python-module-mwlib
BuildRequires: librdmacm-devel >= 1.0.19.1-alt1 libaio-devel zlib-devel liblvm2-devel glib2-devel

Conflicts: %oname

Obsoletes: %oname-libs <= 2.0.0
Obsoletes: %oname-common < 3.1.0
Provides: %name-libs = %version-%release
Provides: %name-common = %version-%release
Provides: %name-core = %version-%release

%description
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package includes the glusterfs binary, the glusterfsd daemon and the
gluster command line, libglusterfs and glusterfs translator modules common to
both GlusterFS server and client framework.

%if 0%{!?_without_rdma:1}
%package rdma
Summary: GlusterFS rdma support for ib-verbs
Group: System/Base
BuildRequires: libibverbs-devel

Requires: %name = %version-%release

%description rdma
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides support to ib-verbs library.
%endif

%if 0%{!?_without_georeplication:1}
%package geo-replication
Summary: GlusterFS Geo-replication
Group: System/Base
Requires: %name = %version-%release , python-modules-ctypes , rsync >= 3.0.0

%description geo-replication
GlusterFS is a clustered file-system capable of scaling to several
peta-bytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file system in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in userspace and easily manageable.

This package provides support to geo-replication.
%endif

%package client
Summary: GlusterFS client
Group: System/Base
BuildRequires: libfuse-devel

Requires: %name = %version-%release

Obsoletes: %name-client < 3.1.0
Provides: %name-client = %version-%release

%description client
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides support to FUSE based clients.

%package server
Summary: Clustered file-system server
Group: System/Servers
Requires: %name = %version-%release
Requires: %name-client = %version-%release

%description server
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the glusterfs server daemon.

%package vim
Summary: Vim syntax file
Group: Editors
Requires: vim-common

%description vim
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

Vim syntax file for GlusterFS.

%package devel
Summary: Development Libraries
Group: Development/Other
Requires: %name = %version-%release
Conflicts: %oname-devel

%description devel
GlusterFS is a clustered file-system capable of scaling to several
petabytes. It aggregates various storage bricks over Infiniband RDMA
or TCP/IP interconnect into one large parallel network file
system. GlusterFS is one of the most sophisticated file systems in
terms of features and extensibility.  It borrows a powerful concept
called Translators from GNU Hurd kernel. Much of the code in GlusterFS
is in user space and easily manageable.

This package provides the development libraries.

%package -n python-module-%name
Summary: Python module for %name
Group: Development/Python
%setup_python_module %name

%description -n python-module-%name
This package provides Python API for %name

%prep
%setup
%patch0 -p1

%build
sed -i 's,3.5git,%version,' configure.ac
./autogen.sh
%configure %{?_without_rdma} %{?_without_epoll} %{?_with_fusermount} %{?_without_georeplication} --localstatedir=/var/ \
	    --enable-qemu-block \
	    --enable-bd-xlator

# Remove rpath
sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool

%make_build

%install
%makeinstall_std
# Install include directory
mkdir -p %buildroot%_includedir/glusterfs
install -p -m 0644 libglusterfs/src/*.h \
%buildroot%_includedir/glusterfs/
install -p -m 0644 contrib/uuid/*.h \
%buildroot%_includedir/glusterfs/
# Following needed by hekafs multi-tenant translator
mkdir -p %buildroot%_includedir/glusterfs/rpc
install -p -m 0644 rpc/rpc-lib/src/*.h \
%buildroot%_includedir/glusterfs/rpc/
install -p -m 0644 rpc/xdr/src/*.h \
%buildroot%_includedir/glusterfs/rpc/
mkdir -p %buildroot%_includedir/glusterfs/server
install -p -m 0644 xlators/protocol/server/src/*.h \
%buildroot%_includedir/glusterfs/server/
# We'll use our init.d
rm -f %buildroot/etc/init.d/glusterd

# Create logging directory
mkdir -p %buildroot%_logdir/glusterfs/

# Remove unwanted files from all the shared libraries
find %buildroot%_libdir -name '*.a' -delete
find %buildroot%_libdir -name '*.la' -delete

# Remove installed docs, we include them ourselves as %%doc
rm -rf %buildroot%_docdir/glusterfs/

# Rename the samples, so we can include them as %%config
#for file in %buildroot%_sysconfdir/glusterfs/*.sample; do
#  mv ${file} `dirname ${file}`/`basename ${file} .sample`
#done

# Create working directory
mkdir -p %buildroot%_sharedstatedir/glusterd



# Update configuration file to /var/lib working directory
sed -i 's|option working-directory %_sysconfdir/glusterd|option working-directory %_sharedstatedir/glusterd|g' \
%buildroot%_sysconfdir/glusterfs/glusterd.vol

# Install init script and sysconfig file
%_init_install %SOURCE7 glusterd
install -D -p -m 0644 %SOURCE1 \
%buildroot%_sysconfdir/sysconfig/glusterd
# Install wrapper umount script
install -D -p -m 0755 %SOURCE3 \
%buildroot/sbin/umount.glusterfs
# Client logrotate entry
install -D -p -m 0644 %SOURCE4 \
%buildroot%_sysconfdir/logrotate.d/glusterfs-fuse
# Server logrotate entry
install -D -p -m 0644 %SOURCE5 \
%buildroot%_sysconfdir/logrotate.d/glusterd
# Legacy server logrotate entry
install -D -p -m 0644 %SOURCE6 \
%buildroot%_sysconfdir/logrotate.d/glusterfsd
# Install vim syntax plugin
install -D -p -m 644 extras/glusterfs.vim \
%buildroot%_datadir/vim/vimfiles/syntax/glusterfs.vim

%files
%doc ChangeLog INSTALL README THANKS COPYING-GPLV2 COPYING-LGPLV3
%_libdir/*.so.*
%_sbindir/glusterfs*
%_sbindir/gluster
%_sbindir/glusterd
%dir %_libdir/glusterfs/
%_libdir/glusterfs/rpc-transport/
%_libdir/glusterfs/auth/
%_libdir/glusterfs/xlator/
%exclude %_libdir/glusterfs/xlator/mount/fuse*
%_logdir/glusterfs
%_man8dir/*gluster*.8*
%exclude %_man8dir/mount.glusterfs.8*
%if 0%{!?_without_rdma:1}
%exclude %_libdir/glusterfs/rpc-transport/rdma*
%endif
%_datadir/glusterfs/scripts/post-upgrade-script-for-quota.sh
%_datadir/glusterfs/scripts/pre-upgrade-script-for-quota.sh


%if 0%{!?_without_rdma:1}
%files rdma
%_libdir/glusterfs/rpc-transport/rdma*
%endif

%if 0%{!?_without_georeplication:1}
%files geo-replication
%dir %_libexecdir/glusterfs/
%_libexecdir/glusterfs/gsyncd
%dir %_libexecdir/glusterfs/python/
%_libexecdir/glusterfs/gverify.sh
%_libexecdir/glusterfs/peer_add_secret_pub
%_libexecdir/glusterfs/peer_gsec_create
%_libexecdir/glusterfs/python/syncdaemon/
%_libexecdir/glusterfs/set_geo_rep_pem_keys.sh
%_datadir/glusterfs/scripts/get-gfid.sh
%_datadir/glusterfs/scripts/slave-upgrade.sh
%_datadir/glusterfs/scripts/gsync-upgrade.sh
%_datadir/glusterfs/scripts/generate-gfid-file.sh
%_bindir//gsync-sync-gfid
%endif


%files client
%config(noreplace) %_sysconfdir/logrotate.d/glusterfs-fuse
%_libdir/glusterfs/xlator/mount/fuse*
%_man8dir/mount.glusterfs.8*
/sbin/mount.glusterfs
/sbin/umount.glusterfs
%if 0%{?_with_fusermount:1}
%_bindir/fusermount-glusterfs
%endif

%files server
%config(noreplace) %_sysconfdir/logrotate.d/glusterd
%config(noreplace) %_sysconfdir/sysconfig/glusterd
%config(noreplace) %_sysconfdir/glusterfs
# Legacy configs
%config(noreplace) %_sysconfdir/logrotate.d/glusterfsd
%_sharedstatedir/glusterd
%_init_file1
%_sbindir/glfsheal

%files vim
%doc COPYING-GPLV2 COPYING-LGPLV3
%_datadir/vim/vimfiles/syntax/glusterfs.vim

%files devel
%_includedir/glusterfs
%exclude %_includedir/glusterfs/y.tab.h
%_libdir/*.so
%_libdir/pkgconfig/glusterfs-api.pc
%_libdir/pkgconfig/libgfchangelog.pc

%files -n python-module-%name
%python_sitelibdir_noarch/*

%post server
%post_service glusterd

%preun server
%preun_service glusterd

%changelog
