%define gimpplugindir %(gimptool-2.0 --gimpplugindir)

Name: gmic
Version: 1.5.3.0
Release: alt1

Summary: GREYC's Magic Image Converter
License: CeCILL v.2.0
Group: Graphics
Url: http://gmic.sourceforge.net/


Source: http://downloads.sourceforge.net/gmic/gmic_%version.tar.gz
Patch1: gmic-1.4.8.1-bashcompletion.patch
Patch2: gmic-1.5.3.0-alt-makefile.patch

Requires: lib%name = %version-%release

BuildRequires: gcc-c++ imake libGraphicsMagick-c++-devel libImageMagick-devel libXext-devel libXrandr-devel
BuildRequires: libavformat-devel libfftw3-devel libgimp-devel libjpeg-devel libopencv-devel libpng-devel
BuildRequires: libswscale-devel libtiff-devel openexr-devel xorg-cf-files zlib-devel
# for zart
BuildRequires: libqt4-devel

%description
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%package -n lib%name
Summary: GREYC's Magic Image Converter Library
Group: System/Libraries

%description -n lib%name
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides shared G'MIC library.

%package -n lib%name-devel
Summary: GREYC's Magic Image Converter Library (development package)
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

This package provides development files for GREYC's Magic Image Converter Library.

%package zart
Summary: GREYC's image processing language demo
Group: Graphics
Requires: lib%name = %version-%release

%description zart
ZArt is a computer program whose purpose is to demonstrate the possibilities of
the G'MIC image processing language by offering the choice of several
manipulations on a video stream acquired from a webcam. In other words, ZArt is
a GUI for G'MIC real-time manipulations on the output of a webcam.

%package -n gimp-plugin-gmic
Summary: Image denoising and interpolation plugin for GIMP
Group: Graphics
Requires: gimp

%description -n gimp-plugin-gmic
G'MIC (GREYC's Magic Image Converter) is an interpreter of image processing
macros whose goal is to convert, manipulate and visualize generic 1D/2D/3D
multi-spectral image datasets.

%prep
%setup -n gmic-%version
%patch1 -p1
%patch2
subst 's|\$(USR)/lib/|$(USR)/%_lib/|' src/Makefile

%build
pushd src
%make_build
popd

%install
pushd src
%makeinstall_std
popd

%find_lang --with-man %name

%files -f %name.lang
%config /etc/bash_completion.d/*
%_bindir/%name
%doc README COPYING

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/gmic.h
%_libdir/lib%name.so

%files zart
%_bindir/zart
%_datadir/zart/
%doc zart/README

%files -n gimp-plugin-gmic
%gimpplugindir/plug-ins/*

%changelog
