%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl
%define hdf5dir %mpidir
%define petsc_dir %_libdir/petsc-real

Name: gmsh
Summary: Automatic 3D finite element grid generator
Version: 2.6.2
Release: alt5.svn20130201
Group: Graphics
License: GPL v2
URL: http://www.geuz.org/gmsh/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://geuz.org/svn/gmsh/trunk/
# login/password: gmsh:gmsh
Source: %name-%version.tar.gz
Source1: CMakeCache.txt

Requires: libcgns-mpi

BuildPreReq: libfltk-devel libjpeg-devel zlib-devel libpng-devel
BuildPreReq: libnetgen-devel libann-devel libchaco-devel chrpath
BuildPreReq: libtetgen-devel getfemxx libGL-devel libGLU-devel libX11-devel
BuildPreReq: libXft-devel libXext-devel libhdf5-mpi-devel %mpiimpl-devel
BuildPreReq: liblapack-devel texlive-base-bin libcairo-devel libavcodec53
BuildPreReq: cmake libICE-devel libSM-devel libparmetis0-devel
BuildPreReq: libXtst-devel libXau-devel libtaucs-devel libgmp-devel
BuildPreReq: libcgns-mpi-devel libXcomposite-devel libpixman-devel
BuildPreReq: libXcursor-devel libXdmcp-devel libXinerama-devel libXpm-devel
BuildPreReq: libXrandr-devel libXt-devel libXv-devel libXxf86misc-devel
BuildPreReq: libslepc-real-devel flex libamesos10 swig
BuildPreReq: libepetraext10 libifpack10 libtrilinos10 libgaleri10
BuildPreReq: libopencascade-devel libmmg3d-devel

%description
Gmsh is an automatic 3D finite element grid generator with a built-in CAD engine
and post-processor. Its design goal is to provide a simple meshing tool for
academic problems with parametric input and advanced visualization capabilities.

Gmsh is built around four modules: geometry, mesh, solver and post-processing.
The specification of any input to these modules is done either interactively
using the graphical user interface or in ASCII text files using Gmsh's own
scripting language.

%package demos
Summary: Tutorial and demo files for Gmsh
Group: Graphics
BuildArch: noarch

%description demos
Gmsh is an automatic 3D finite element grid generator with a built-in CAD engine
and post-processor. Its design goal is to provide a simple meshing tool for
academic problems with parametric input and advanced visualization capabilities.

Gmsh is built around four modules: geometry, mesh, solver and post-processing.
The specification of any input to these modules is done either interactively
using the graphical user interface or in ASCII text files using Gmsh's own
scripting language.

This package contains tutorial and demo files for Gmsh.

%prep
%setup

install -p -m644 %SOURCE1 .
sed -i 's|@LIBDIR@|%_libdir|g' CMakeCache.txt
sed -i 's|@MPIDIR@|%mpidir|g' CMakeCache.txt
sed -i 's|@PETSC_DIR@|%petsc_dir|g' CMakeCache.txt
%ifarch x86_64
LIB64=64
%endif
sed -i "s|@64@|$LIB64|g" CMakeCache.txt

# avoid conflict with defs.h in other packages
ln -s defs.h contrib/Chaco/main/chaco_defs.h
CHACO_FILES="$(egrep -R 'defs\.h' contrib/Chaco/|awk -F : '{print $1}')"
sed -i 's|defs\.h|chaco_defs.h|' $CHACO_FILES

rm -fR contrib/{ANN,Metis,mmg3d}

%build
mpi-selector --set %mpiimpl
source %_bindir/petsc-real.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib -L%_libdir/oski"
export LD_LIBRARY_PATH=%_libdir/oski

cmake \
%ifarch x86_64
	-DLIB_SUFFIX:STRING=64 \
%endif
	-DMPIDIR:PATH=%mpidir \
	.
%make_build VERBOSE=1
%make info

%install
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib -l%_libdir/oski"
export LD_LIBRARY_PATH=%_libdir/oski

%makeinstall_std

#for i in %buildroot%_bindir/* %buildroot%_libdir/*.so; do
for i in %buildroot%_bindir/*; do
	chrpath -r %mpidir/lib:%petsc_dir/lib $i
done

install -d %buildroot%_infodir
install -m644 doc/texinfo/*.info* %buildroot%_infodir

install -p -m644 doc/*.html %buildroot%_docdir/%name

# antirepocop
rm -fR %buildroot%_includedir

%filter_from_requires /^debug.*(libcgns\.so.*/s/^/libcgns-mpi-debuginfo\t/

%files
%dir %_docdir/%name
%doc %_docdir/%name/*.txt
%doc %_docdir/%name/*.html
%_bindir/*
%_man1dir/*
%_infodir/*
#_libdir/*.so

%files demos
%dir %_docdir/%name
%_docdir/%name/demos
%_docdir/%name/tutorial

%changelog
