%define ver_major 3.8
%define _libexecdir %_prefix/libexec

%def_enable introspection
%def_enable geoclue
%def_enable gtk_doc

Name: gnome-bluetooth
Version: %ver_major.2.1
Release: alt0.M70P.1

Summary: The GNOME Bluetooth Subsystem
License: GPLv2/LGPLv2
Group: System/Libraries
Url: https://live.gnome.org/GnomeBluetooth

Provides: bluez-gnome = %version
Obsoletes: bluez-gnome < %version
Conflicts: blueman < 1.10-alt4
Requires: lib%name = %version-%release bluez obex-data-server obexd rfkill

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
# https://bugzilla.redhat.com/show_bug.cgi?id=514798
Source1: 61-gnome-bluetooth-rfkill.rules
Patch: %name-3.7.4-alt-gir.patch

BuildRequires: gnome-common gtk-doc intltool yelp-tools itstool
BuildRequires: libgio-devel libgtk+3-devel libnotify-devel libXi-devel libdbus-glib-devel
%{?_enable_geoclue:BuildRequires: libgeoclue-devel}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}

%description
The GNOME Bluetooth Subsystem

%package -n lib%name
Summary: The GNOME Bluetooth Subsystem library
Group: System/Libraries

%description -n lib%name
This package provides GNOME Bluetooth Subsystem library

%package -n lib%name-gir
Summary: GObject introspection data for the GNOME Bluetooth library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GNOME Bluetooth library

%package -n lib%name-devel
Summary: The GNOME Bluetooth Subsystem development package
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides GNOME Bluetooth Subsystem development files

%package -n lib%name-devel-doc
Summary: The GNOME Bluetooth Subsystem development documentation
Group: Development/C
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package provides GNOME Bluetooth Subsystem development documentation

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the GNOME Bluetooth library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name = %version-%release
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the GNOME Bluetooth library

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--disable-schemas-compile \
	--disable-icon-update \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection}
%make_build

%install
%make DESTDIR=%buildroot install

install -pD -m0644 %{SOURCE1} %buildroot/lib/udev/rules.d/61-gnome-bluetooth-rfkill.rules

# temporarily fix for gnome-shell that requires libgnome-bluetooth-applet library
for f in %buildroot%_libdir/%name/lib%name-applet*; do
ln -s %name/`basename $f` %buildroot%_libdir/`basename $f`
done

mv %buildroot%_bindir/bluetooth-sendto %buildroot%_bindir/%name-sendto
mkdir -p %buildroot%_altdir
cat > %buildroot%_altdir/%name <<EOF
%_bindir/bluetooth-sendto	%_bindir/%name-sendto	10
EOF

find %buildroot -name "*.la" -delete

%find_lang --with-gnome --output=global.lang %name gnome-bluetooth2


%files -f global.lang
%doc AUTHORS README NEWS
%_altdir/%name
%_bindir/*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/*.so
/lib/udev/rules.d/61-gnome-bluetooth-rfkill.rules
%_desktopdir/*.desktop
%_datadir/%name
%_iconsdir/hicolor/*/*/*
%_man1dir/*.1*

%files -n lib%name
%_libdir/*.so.*
%_libdir/%name/lib%name-applet.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/%name/lib%name-applet.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/GnomeBluetoothApplet-1.0.typelib
%_typelibdir/GnomeBluetooth-1.0.typelib

%files -n lib%name-gir-devel
%_girdir/GnomeBluetooth-1.0.gir
%endif

%changelog
