%define ver_major 3.8
%def_enable clutter
# tests require colord running and g-c-m installed
%def_disable check

Name: gnome-color-manager
Version: %ver_major.4
Release: alt0.M70P.1

Summary: Color profile manager for the GNOME desktop
License: %gpl2plus
Group: Graphical desktop/GNOME
Url: http://www.gnome.org/projects/gnome-color-manager/

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Obsoletes: libcolor-glib
Requires: common-licenses gnome-session gnome-filesystem

BuildPreReq: gnome-common rpm-build-gnome
BuildPreReq: rpm-build-licenses

# From configure.in
%define gio_ver 2.31.10
%define clutter_ver 1.12
%define gtk_ver 3.0
%define vte_ver 0.27.2
%define notify_ver 0.7.3
%define colord_ver 0.1.24
%define lcms_ver 2.2

BuildRequires: gcc-c++ intltool gtk-doc yelp-tools itstool
BuildRequires: docbook-utils xsltproc
BuildPreReq: libgio-devel >= %gio_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libvte3-devel >= %vte_ver
BuildPreReq: libnotify-devel >= %notify_ver
BuildPreReq: colord-devel >= %colord_ver
BuildPreReq: libcolord-gtk-devel >= %colord_ver
BuildRequires: libgnome-desktop3-devel libexif-devel libexiv2-devel libcanberra-gtk3-devel
BuildRequires: libtiff-devel liblcms2-devel >= %lcms_ver libXrandr-devel
%{?_enable_clutter:BuildRequires: libclutter-devel >= %clutter_ver libclutter-gtk3-devel libmash-devel}
%{?_enable_check:BuildRequires: /proc xvfb-run}

%description
gnome-color-manager is a session program that makes it easy to manage,
install and generate color profiles in the GNOME desktop.

This project has the following features:

* Setting output gamma tables (with local brightness and adjustments) to any
  Xrandr output (falling back to the per-screen methods for drivers that do not
  yet support Xrandr 1.3).

* Setting of settings at session start, and when monitors are hotplugged.

* Easy install of vendor supplied ICC or ICM files, just by double clicking
  on the file.

* Easy display calibration using an external calibration device, and scanner
  calibration using a inexpensive IT 8.7 target. For calibration, the ArgyllCMS
  package is required.

* Integration X11 by setting the per-screen and per-output _ICC_PROFILE atom,
  which makes applications such as the GIMP use a color managed output.

* Easy to use DBus interface for applications to query what ICC profiles should
  be used for a specific device. This is session activated and is only started
  when it is needed, and quits after a small period of idleness.

%define libexecdir %_prefix/libexec

%prep
%setup -q

%build
%configure \
    --disable-static \
    --enable-tests \
    --disable-schemas-compile \
    %{subst_enable clutter}

%make_build

%install
%make_install DESTDIR=%buildroot install

# The license
ln -sf %_licensedir/GPL-2 COPYING

%find_lang --with-gnome %name

%check
%{?_enable_check:xvfb-run %make check}

%files -f %name.lang
%_bindir/gcm-calibrate
%_bindir/gcm-import
%_bindir/gcm-inspect
%_bindir/gcm-picker
%_bindir/gcm-viewer
%_libexecdir/gcm-helper-exiv
%_datadir/%name/
%_datadir/applications/*.desktop
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_iconsdir/hicolor/*x*/mimetypes/*.png
%_iconsdir/hicolor/scalable/mimetypes/*.svg
%_man1dir/*
%doc --no-dereference COPYING
%doc README NEWS AUTHORS

%changelog
