%def_disable snapshot

%define _libexecdir %_prefix/libexec
%define _name control-center
%define ver_major 3.8
%define api_ver 2.0

%def_disable debug
%def_disable static
%def_without libsocialweb
%def_with cheese

Name: gnome-control-center
Version: %ver_major.6
Release: alt0.M70P.1

Summary: GNOME Control Center
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

# git archive --format=tar --prefix=gnome-control-center-3.2.2/ --output=gnome-control-center-3.2.2.tar HEAD
%if_enabled snapshot
Source: %name-%version.tar
%else
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%endif
Patch: %name-3.8.3-alt-lfs.patch
Patch1: %name-3.10.1-alt-background_build.patch

# From configure.ac
%define gtk_ver 3.5.13
%define glib_ver 2.35.1
%define desktop_ver 3.5.91
%define fontconfig_ver 1.0.0
%define xft_ver 2.1.2
%define libmetacity_ver 2.30.0
%define gsds_ver 3.7.91
%define nm_ver 0.9.1.90
%define gnome_menus_ver 3.7.90
%define goa_ver 3.7.91
%define acc_ver 0.6.30
%define sett_daemon_ver 3.8.6
%define cheese_ver 3.5.92
%define bt_ver 3.5.92
%define systemd_ver 40
%define wacom_ver 0.7
%define ibus_ver 1.4.99
%define colord_ver 0.1.29

Requires: %name-data = %version-%release

# For /usr/share/gnome
Requires: gnome-filesystem
Requires: gnome-settings-daemon >= %sett_daemon_ver
# for graphical passwd changing apps
Requires: accountsservice
#Requires: userpasswd
Requires: gnome-online-accounts >= %goa_ver
%{?_with_cheese:Requires: cheese >= %cheese_ver}
BuildPreReq: rpm-build-gnome >= 0.9

# From configure.in
BuildPreReq: intltool >= 0.50 gnome-common desktop-file-utils gnome-doc-utils gtk-doc xsltproc
BuildPreReq: fontconfig-devel >= %fontconfig_ver
BuildPreReq: libXft-devel >= %xft_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: gsettings-desktop-schemas-devel >= %gsds_ver
BuildPreReq: gnome-settings-daemon-devel >= %sett_daemon_ver
BuildPreReq: libcolord-devel >= %colord_ver
BuildPreReq: libcolord-gtk-devel
BuildPreReq: libgnome-menus-devel >= %gnome_menus_ver
BuildPreReq: libibus-devel >= %ibus_ver libxkbfile-devel
BuildRequires: libupower-devel libpolkit1-devel
BuildRequires: libgio-devel librsvg-devel libxml2-devel libcanberra-gtk3-devel
BuildRequires: libX11-devel libXext-devel libSM-devel libXScrnSaver-devel libXt-devel
BuildRequires: libXft-devel libXi-devel libXrandr-devel libXrender-devel libXcursor-devel libXcomposite-devel
BuildRequires: libgtop-devel libcups-devel libpulseaudio-devel iso-codes-devel
BuildRequires: libpwquality-devel libkrb5-devel libsmbclient-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
# for test-endianess
BuildRequires: glibc-i18ndata
BuildRequires: libnm-gtk-devel >= %nm_ver
BuildRequires: libmm-glib-devel
BuildRequires: libgnome-online-accounts-devel >= %goa_ver
BuildRequires: libaccountsservice-devel >= %acc_ver
BuildRequires: libgnome-bluetooth-devel >= %bt_ver
BuildRequires: libwacom-devel >= %wacom_ver
BuildRequires: libclutter-gtk3-devel
BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel
%{?_with_cheese:BuildPreReq: libcheese-devel >= %cheese_ver}
%{?_with_libsocialweb:BuildRequires: libsocialweb-devel}

%description
GNOME (the GNU Network Object Model Environment) is an attractive and
easy-to-use GUI desktop environment. The control-center package
provides the GNOME Control Center utilities that allow you to setup
and configure your system's GNOME environment (things like the desktop
background and theme, the screensaver, the window manager, system
sounds, and mouse behavior).

If you install GNOME, you need to install control-center.

%package data
Summary: Arch independent files for GNOME Control Center
Group: Networking/Instant messaging
BuildArch: noarch

%description data
This package provides noarch data needed for GNOME Control Center to work.

%package devel
Summary: GNOME Control Center development files
Group: Development/GNOME and GTK+
BuildArch: noarch
Requires: %name = %version-%release

%description devel
If you're interested in developing panels for the GNOME control center,
you'll want to install this package.

%name-devel helps you create the panels for the control center.

%prep
%setup
%patch -p1 -b .lfs
%patch1

%build
%if_enabled snapshot
NOCONFIGURE=1 ./autogen.sh
%else
%autoreconf
%endif
%configure \
    %{subst_enable static} \
    %{subst_with libsocialweb} \
    %{subst_with cheese}

%make_build

%install
%make_install DESTDIR=%buildroot install
%find_lang --with-gnome --output=%name.lang %name-%api_ver %name-%api_ver-timezones %_name

%files
%_bindir/%name
%_libexecdir/cc-remote-login-helper
%_libexecdir/gnome-control-center-search-provider

%files data -f %name.lang
%dir %_datadir/%name
%_datadir/%name/keybindings
%_datadir/%name/pixmaps
%dir %_datadir/%name/sounds
%_datadir/%name/sounds/gnome-sounds-default.xml
%dir %_datadir/%name/datetime
%_datadir/%name/datetime/backward
%_datadir/%name/icons/
%_desktopdir/*.desktop
%_datadir/pixmaps/faces/
%_iconsdir/hicolor/*/*/*
%_datadir/sounds/gnome/default/alerts/*.ogg
%_datadir/polkit-1/actions/org.gnome.controlcenter.datetime.policy
%_datadir/polkit-1/actions/org.gnome.controlcenter.user-accounts.policy
%_datadir/polkit-1/rules.d/gnome-control-center.rules
%_datadir/polkit-1/actions/org.gnome.controlcenter.remote-login-helper.policy
%_datadir/dbus-1/services/org.gnome.ControlCenter.SearchProvider.service
%_datadir/gnome-shell/search-providers/gnome-control-center-search-provider.ini
%_man1dir/%name.1.*
%_datadir/bash-completion/completions/gnome-control-center
%doc AUTHORS NEWS README

%files devel
%_datadir/pkgconfig/gnome-keybindings.pc

%changelog
