%define ver_major 3.8

Name: gnome-devel-docs
Version: %ver_major.1
Release: alt1

Summary: General GNOME Developper Documentation
License: %fdl
Group: Graphical desktop/GNOME
Url: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Obsoletes: gnome-users-guide
Provides: gnome-users-guide
Obsoletes: gnome2-user-docs
Provides: gnome2-user-docs

BuildPreReq: rpm-build-gnome rpm-build-licenses
BuildPreReq: yelp-tools
BuildRequires: intltool xml-utils xsltproc
#BuildPreReq: rpm-build-gir

%description
This package contains documents which are targeted for GNOME developers.
It provides the Platform Overview, Human Interface Guidelines, the
Integration Guide, the Documentation Style Guide, the Accessibility
Guide and the Handbook of Writing Software Documentation.

%package -n gnome-devel-demos
Summary: GNOME Developer Platform demos
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description -n gnome-devel-demos
This package is a part of %name and provides demos for GNOME developpers

%prep
%setup

%build

%autoreconf
%configure
%make_build

%install

%make_install DESTDIR=%buildroot install

%find_lang --with-gnome --output=%name.lang hig-book integration-guide platform-overview optimization-guide accessibility-devel-guide

%files -f %name.lang
%doc AUTHORS README NEWS

%files -n gnome-devel-demos
%_datadir/help/*/gnome-devel-demos/

%changelog
