%define _libexecdir %_prefix/libexec

Name: gnome-disk-utility
Version: 3.8.2
Release: alt1

Summary: Disk management application
License: LGPLv2+
Group: System/Libraries
URL: http://git.gnome.org/cgit/gnome-disk-utility
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: udisks2 cryptsetup

Source: %name-%version.tar.xz
Patch: %name-3.8.0-alt-lfs.patch

%define udisks_ver 2.1.0
%define glib_ver 2.31.0
%define gtk_ver 3.5.8
%define secret_ver 0.7
%define pwquality_ver 1.0.0
%define gsd_ver 3.6
%define dvdread_ver 4.2.0

BuildRequires: gnome-common intltool xsltproc
BuildPreReq: libudisks2-devel >= %udisks_ver
BuildPreReq: libgio-devel  >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libsecret-devel >= %secret_ver
BuildPreReq: libpwquality-devel >= %pwquality_ver
BuildPreReq: gnome-settings-daemon-devel >= %gsd_ver
BuildPreReq: libdvdread-devel >= %dvdread_ver
BuildRequires: libnotify-devel libcanberra-gtk3-devel
BuildRequires: systemd-devel libsystemd-login-devel
BuildRequires: xsltproc docbook-style-xsl

%description
This package contains the Palimpsest disk management application.
Palimpsest supports partitioning, file system creation, encryption,
RAID, SMART monitoring, etc

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

%find_lang --with-gnome --output=global.lang %name palimpsest

%files -f global.lang
%_bindir/gnome-disk-image-mounter
%_bindir/gnome-disks
%_desktopdir/gnome-disk-image-mounter.desktop
%_desktopdir/gnome-disks.desktop
%_datadir/%name/
%_datadir/glib-2.0/schemas/org.gnome.Disks.gschema.xml
%_iconsdir/hicolor/*/apps/*
%_iconsdir/HighContrast/*x*/apps/gnome-disks.png
%_man1dir/*.1.*
# gsd plugin
%_libdir/gnome-settings-daemon-3.0/gdu-sd-plugin.gnome-settings-plugin
%_libdir/gnome-settings-daemon-3.0/libgdu-sd.so
%_datadir/glib-2.0/schemas/org.gnome.settings-daemon.plugins.gdu-sd.gschema.xml

%exclude %_libdir/gnome-settings-daemon-3.0/libgdu-sd.la

%changelog
