%define ver_major 0.20

%undefine _configure_target

Name: gnome-doc-utils
Version: %ver_major.10
Release: alt2

Summary: Documentation utilities for GNOME
Group: Development/Other
License: %gpl2plus
Url: http://www.gnome.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
Source1: scrollkeeper-omf.dtd
# GNOME bug #524207
Patch1: gnome-doc-utils-0.14.0-package.patch
Patch2: gnome-doc-utils-fig-path.patch

%define pkgdocdir %_docdir/%name-%version

%define libxml_version 2.6.12
%define libxslt_version 1.1.8

Requires: %name-xslt = %version-%release
Requires: librarian
Requires: python-modules-encodings

%add_python_compile_include %python_sitelibdir/xml2po

BuildArch: noarch

BuildPreReq: rpm-build-python rpm-build-licenses rpm-build-gnome intltool
BuildRequires: libxml2-devel >= %libxml_version
BuildRequires: libxslt-devel >= %libxslt_version
BuildRequires: python-devel python-module-libxml2 python-modules-encodings
BuildRequires: db2latex-xsl docbook-dtds librarian xsltproc

%description
gnome-doc-utils is a collection of documentation utilities for the Gnome
project. It contains the DocBook XSLT stylesheets that were once
distributed with Yelp.

%package xslt
Summary: XSLT stylesheets for %name
Group: Development/Other
License: %lgpl2plus

%description xslt
XSLT stylesheets from the gnome-doc-utils collection.

%prep
%setup
cp %SOURCE1 doc/

%if 0
%_bindir/xmlcatalog --create --noout catalog
%_bindir/xmlcatalog --noout --add "public" \
"-//OMF//DTD Scrollkeeper OMF Variant V1.0//EN" \
"doc/scrollkeeper-omf.dtd" catalog
export SGML_CATALOG_FILES=catalog
%endif

%patch1 -p1 -b .package
%patch2 -p1 -b .fig

# Update URLs of external entities to fix build in isolated network environment.
find -type f -print0 |
	xargs -r0 grep -lZ "'http://[^']*/scrollkeeper-omf[.]dtd'" |
	xargs -r0 sed -i "s|'http://[^']*/scrollkeeper-omf[.]dtd'|'/usr/share/xml/scrollkeeper/dtds/scrollkeeper-omf.dtd'|" --

%build
export am_cv_python_pythondir=%python_sitelibdir
%configure --disable-scrollkeeper
# SMP-incompatible build
%make

%check
%make check

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang gnome-doc-make gnome-doc-xslt gnome-doc-mallard-spec gnome-doc-utils

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS README NEWS COPYING %buildroot%pkgdocdir/
ln -s %_licensedir/GPL-2 %buildroot%pkgdocdir/COPYING.GPL
ln -s %_licensedir/LGPL-2.1 %buildroot%pkgdocdir/COPYING.LGPL

%files -f %name.lang
%_bindir/*
%_datadir/pkgconfig/*
%_datadir/aclocal/*
%_datadir/%name
%dir %_datadir/xml/mallard/1.0/
%_datadir/xml/mallard/1.0/*
%_man1dir/*
#python
%python_sitelibdir/xml2po/
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/COPYING
%pkgdocdir/COPYING.GPL
%pkgdocdir/NEWS
%pkgdocdir/README

%files xslt
%pkgdocdir/COPYING.LGPL
%_datadir/xml/gnome

%changelog
