%define _unpackaged_files_terminate_build 1

%define _name chess
%define __name gnome-%_name
%define ver_major 3.8
%define _libexecdir %_prefix/libexec

Name: gnome-games-%_name
Version: %ver_major.5
Release: alt0.M70P.1

Summary: A chess game for GNOME
Group: Games/Boards
License: GPLv3+
Url: https://live.gnome.org/Chess

Source: ftp://ftp.gnome.org/pub/gnome/sources/%__name/%ver_major/%__name-%version.tar.xz

Provides:  %__name = %version-%release
Obsoletes: gnome-games-glchess
Provides:  gnome-games-glchess = %version-%release

%define glib_ver 2.32.0
%define gtk_ver 3.4.0
%define vala_ver 0.16.0

BuildRequires: gnome-common
BuildRequires: intltool yelp-tools libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver librsvg-devel
BuildRequires: libsqlite3-devel libGL-devel libGLU-devel vala-tools >= %vala_ver

%description
A chess game which supports several chess engines, with 2D and optionally
3D support if OpenGL is present.

%prep
%setup -n %__name-%version
[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang --with-gnome %__name

%files -f gnome-%_name.lang
%_bindir/%__name
%_desktopdir/glchess.desktop
%_datadir/%__name
%_iconsdir/hicolor/*x*/apps/%__name.png
%_iconsdir/hicolor/scalable/apps/%__name.svg
%_man6dir/%__name.*
%config %_datadir/glib-2.0/schemas/org.gnome.%__name.gschema.xml

%changelog
