%define ver_major 3.8
%define gtk_api_ver 2.0

Name: gnome-icon-theme
Version: %ver_major.3
Release: alt1

Summary: A set of icons for GNOME 2 desktop
License: LGPL
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

BuildArch: noarch

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Provides: icon-theme-gnome = %version-%release

%define icon_naming_utils_ver 0.8.7

Requires: icon-naming-utils >= %icon_naming_utils_ver

# From configure.in
BuildPreReq: intltool >= 0.40.0
BuildPreReq: pkgconfig >= 0.19
BuildPreReq: icon-naming-utils >= %icon_naming_utils_ver
BuildRequires: gtk-update-icon-cache perl-XML-Parser

%description
The standard set of icons for Gnome.

%prep
%setup -q

%build
%configure
%make_build

%install
%make_install DESTDIR=%buildroot install
ln -s gnome %buildroot%_iconsdir/default.gnome

%find_lang %name

%define conf_string gtk-icon-theme-name = \"gnome\"
%define gtkrc %_sysconfdir/gtk-%{gtk_api_ver}/gtkrc

%post
if [ -f %gtkrc ]; then
        grep -qs '^%conf_string$' %gtkrc ||
        echo '%conf_string' >> %gtkrc
fi

%postun
[ $1 = 0 ] || exit 0
if [ -f %gtkrc ]; then
	subst '/%conf_string/d' %gtkrc
fi ||:

%triggerin -- libgtk+2-common
if [ -f %gtkrc ]; then
        grep -qs '^%conf_string$' %gtkrc ||
        echo '%conf_string' >> %gtkrc
fi

%triggerpostun -- libgtk+2-common < 2.12.11-alt1
[ $2 != 0 ] || exit 0
if [ -f %gtkrc ]; then
        grep -qs '^%conf_string$' %gtkrc ||
        echo '%conf_string' >> %gtkrc
fi

%files -f %name.lang
%dir %_iconsdir/gnome
%_iconsdir/gnome/*
%_iconsdir/default.gnome
%_datadir/pkgconfig/*
%doc AUTHORS README TODO

%changelog
