%define ver_major 3.8
%def_disable static
%def_disable gtk_doc
%def_disable debug
%def_disable valgrind
%def_enable pam
%def_enable selinux

Name: gnome-keyring
Version: %ver_major.1
Release: alt1

Summary: %name is a password keeper for GNOME
License: LGPL
Group: Graphical desktop/GNOME
Url: http://www.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Patch: gnome-keyring-3.6.3-alt-lfs.patch

%define glib_ver 2.32.0
%define dbus_ver 1.0
%define gcrypt_ver 1.2.2
%define tasn1_ver 0.3.4
%define p11kit_ver 0.16
%define gcr_ver 3.7.91

Requires: libp11-kit >= %p11kit_ver

# From configure.in
BuildPreReq: gnome-common glib2-devel >= %glib_ver libgio-devel
BuildPreReq: intltool >= 0.35.0 gtk-doc
BuildPreReq: libdbus-devel >= %dbus_ver
BuildPreReq: libgcrypt-devel >= %gcrypt_ver
BuildPreReq: libtasn1-devel >= %tasn1_ver libtasn1-utils libcap-ng-devel libp11-kit-devel >= %p11kit_ver
BuildPreReq: gcr-libs-devel >= %gcr_ver
%{?_enable_pam:BuildPreReq: libpam-devel}
%{?_enable_valgrind:BuildPreReq: valgrind}
%{?_enable_selinux:BuildRequires: libselinux-devel}
# for check
BuildRequires: xvfb-run

%description
%name is a program that keep password and other secrets for
users. It is run as a damon in the session, similar to ssh-agent, and
other applications can locate it by an environment variable.

%package -n pam_%name
Summary: A pam module for unlocking keyrings at login time
Group: System/Base
Requires: %name = %version-%release

%description -n pam_%name
The pam_gnome-keyring package contains a pam module that can
automatically unlock the "login" keyring when the user logs in
and start the keyring daemon.

%define _gtk_docdir %_datadir/gtk-doc/html
%define _libexecdir %_prefix/libexec/%name

%prep
%setup
%patch -p1 -b .lfs

%build
%autoreconf
%configure \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable static} \
	%{subst_enable debug} \
	%{subst_enable valgrind} \
	%{subst_enable selinux} \
	--with-pam-dir=/%_lib/security


%make_build

%check
#** (test-data-der:3746): CRITICAL **: egg_symkey_generate_pkcs12: assertion `iterations > 0' failed
#FAIL
#xvfb-run %make check

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/*
%_datadir/dbus-1/services/org.gnome.keyring.service
%_datadir/dbus-1/services/org.freedesktop.secrets.service
%_sysconfdir/xdg/autostart/*.desktop
%config %_datadir/glib-2.0/schemas/org.gnome.crypto.cache.gschema.xml
%_datadir/GConf/gsettings/org.gnome.crypto.cache.convert
%_datadir/p11-kit/modules/gnome-keyring.module
%_libdir/gnome-keyring
%_libdir/pkcs11

%exclude %_libdir/pkcs11/gnome-keyring-pkcs11.la
%exclude %_libdir/gnome-keyring/*/*.la

%doc README AUTHORS NEWS

%if_enabled pam
%files -n pam_%name
/%_lib/security/*
%endif

%exclude /%_lib/security/*.la

%changelog
