%define ver_major 3.4
%def_disable static
%def_disable gstmix

Name: gnome-media
Version: %ver_major.0
Release: alt1

%define pkgdocdir %_docdir/%name-%version

Summary: GNOME media programs
License: LGPLv+2
Group: Graphical desktop/GNOME
URL: ftp://ftp.gnome.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Patch: %name-2.26.0-alt-gst-mixer.patch

Provides: gnome2-media = %version
Obsoletes: gnome2-media

# From configure.ac
%define GConf_ver 2.10.0
%define scrollkeeper_ver 0.3.14
%define intltool_ver 0.35
%define glib_ver 2.18.2
%define gtk_ver 2.91.0
%define gstreamer_ver 0.10.23
%define gstreamer_plugins_ver 0.10.0
%define libxml_ver 2.5.0
%define gnome_common_ver 2.8.0

%{?_enable_gstmix:Requires: %name-gmix = %version-%release}
Requires: %name-grecord = %version-%release

BuildRequires: GConf >= %GConf_ver libGConf-devel >= %GConf_ver
BuildRequires: scrollkeeper >= %scrollkeeper_ver
BuildRequires: intltool >= %intltool_ver gnome-doc-utils
BuildRequires: gnome-common >= %gnome_common_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: gstreamer-devel >= %gstreamer_ver
BuildRequires: gstreamer-utils >= %gstreamer_ver
BuildRequires: gst-plugins-devel >= %gstreamer_plugins_ver
BuildRequires: libxml2-devel >= %libxml_ver
BuildRequires: libcanberra-gtk3-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libgnome-media-profiles-devel

%description
GNOME media programs for the GNOME 3 desktop contains the following:

grecord                 - GNOME Sound Recorder.
gstreamer-properties    - GStreamer Properties Capplet.
gst-mixer               - GNOME GStreamer-based audio mixer. (deprecated)

%package common
Summary: Common files for GNOME media programs
Group: Graphical desktop/GNOME
PreReq: GConf >= %GConf_ver
PreReq: scrollkeeper >= %scrollkeeper_ver

Requires: gstreamer(audio-hardware-sink) >= %gstreamer_plugins_ver
Requires: gst-plugins-audio-filters >= %gstreamer_plugins_ver
Requires: gst-plugins-gconf >= %gstreamer_plugins_ver
Requires: gst-plugins-test >= %gstreamer_plugins_ver
Requires: gst-plugins-video-filters >= %gstreamer_plugins_ver

Provides: gnome2-media-common = %version
Obsoletes: gnome2-media-common

%description common
This package contains common files needed to run GNOME media programs.

%package gmix
Summary: GNOME GStreamer-based audio mixer.
Group: Sound
PreReq: %name-common = %version-%release
Requires: pulseaudio-daemon >= 0.9.16
# ALT #2431
Requires: alsa-plugins-pulse

%description gmix
gnome-volume-control is a GNOME enabled audio mixer.

%package grecord
Summary: GNOME Sound recorder.
Group: Sound
PreReq: %name-common = %version-%release
Requires: gstreamer(audio-hardware-source) >= %gstreamer_plugins_ver
Requires: gst-plugins-base >= %gstreamer_plugins_ver

%description  grecord
The application enables you to record and play waveform .wav sound files.

%define _libexecdir %_bindir

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
    --disable-schemas-install \
    %{subst_enable static} \
    %{subst_enable vumeter} \
    %{subst_enable cddbslave} \
    %{subst_enable gnomecd} \
    %{subst_enable gstmix}

%make_build

%install
%make_install DESTDIR=%buildroot install

%define programs grecord gnome-sound-recorder gstreamer-properties
%find_lang --with-gnome %name %name-2.0 %programs

for omf in %programs; do
grep -F "$omf" %name.lang >> $omf.lang ||:
done

grep -v '\.omf$' %name.lang >> %name-2.0.lang
cat gstreamer-properties.lang >> %name-2.0.lang
cat gnome-sound-recorder.lang >> grecord.lang

install -d -m755 %buildroot%pkgdocdir
install -p -m644 AUTHORS MAINTAINERS NEWS README \
    %buildroot%pkgdocdir/

%post grecord
%gconf2_install gnome-sound-recorder

%preun grecord
if [ $1 = 0 ]; then
%gconf2_uninstall gnome-sound-recorder
fi

%files

%files common -f %name-2.0.lang
%_bindir/gstreamer-properties
%_desktopdir/gstreamer-properties.desktop
%_datadir/gstreamer-properties
%_datadir/%name
%_datadir/sounds/gnome/default/alerts/*.ogg
%_iconsdir/hicolor/*x*/apps/gstreamer-properties.png
%dir %pkgdocdir
%pkgdocdir/AUTHORS
%pkgdocdir/MAINTAINERS
%pkgdocdir/NEWS
%pkgdocdir/README

%if_enabled gstmix
%files gmix -f gnome-volume-control.lang
# gstmix
%_bindir/gnome-volume-control-settings
%_desktopdir/gnome-volume-control-settings.desktop
%endif

%files grecord -f grecord.lang
%_bindir/gnome-sound-recorder
%_desktopdir/gnome-sound-recorder.desktop
%_datadir/gnome-sound-recorder
%_iconsdir/hicolor/*/*/gnome-sound-recorder.*
%config %_sysconfdir/gconf/schemas/gnome-sound-recorder.*

%changelog
