%define ver_major 3.8
%define _name mousetweaks

Name: gnome-%_name
Version: %ver_major.0
Release: alt1

Summary: Mouse accessibility enhancements
License: %gpl3plus
Group: Graphical desktop/GNOME
Url: https://live.gnome.org/Mousetweaks/Home
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%_name-%version.tar.xz

BuildPreReq: rpm-build-gnome rpm-build-licenses

# From configure.ac
BuildPreReq: gnome-common
BuildPreReq: intltool >= 0.40.0
BuildPreReq: libgio-devel >= 2.28.5
BuildPreReq: libgtk+3-devel >= 3.0.7
BuildPreReq: libXfixes-devel libXcursor-devel libXtst-devel
BuildPreReq: libX11-devel libXi-devel libXext-devel xorg-xextproto-devel
BuildRequires: gsettings-desktop-schemas-devel

%description
The Mousetweaks package provides mouse accessibility enhancements for
the GNOME desktop. These enhancements are: 1. It offers a way to perform
the various clicks without using any hardware button. (hover click)

2. It allows users to perform a secondary click by keeping the primary
mousebutton pressed for a determined amount of time. (simulated
secondary click)

3. For desktops using the gnome-panel, it provides two panel applets
that the user can install on the gnome-panels. - The first applet
provides an alternative way to control the hover click. - The second
applet creates an area on the panel into which the pointer can be
captured until the user releases it with a predefined button and
modifier combination.

The hover click and the simulated secondary click can be accessed
through the Universal Access control panel in the GNOME Control Center.
The applets however can only be accessed on desktops using the
gnome-panel.

%prep
%setup -q -n %_name-%version

%build
%configure \
	--disable-schemas-compile


%make_build

%install
%make_install DESTDIR=%buildroot install

%find_lang --with-gnome %_name

%define schemas  %_name pointer-capture-applet

%files -f %_name.lang
%_bindir/*
%_datadir/%_name
%_man1dir/*
%config %_datadir/glib-2.0/schemas/*
%_datadir/GConf/gsettings/*
%doc AUTHORS ChangeLog NEWS README

%changelog
