%define ver_major 3.8

Name: gnome-power-manager
Version: %ver_major.2
Release: alt1

Summary: GNOME Power management tools
License: %gpl2plus
Group: Graphical desktop/GNOME
Url: http://www.gnome.org/projects/gnome-power-manager/

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Requires: common-licenses gnome-session gnome-filesystem
Requires: upower >= 0.9.7

BuildPreReq: rpm-build-gnome >= 0.5
BuildPreReq: rpm-build-licenses

# From configure.in
BuildPreReq: intltool >= 0.35.0
BuildPreReq: gnome-doc-utils >= 0.3.2
BuildPreReq: glib2-devel >= 2.31.10
BuildPreReq: libgtk+3-devel >= 3.3.8
BuildPreReq: libupower-devel >= 0.9.1
# for docbook2man
BuildPreReq: docbook-utils
BuildPreReq: gnome-common

%description
GNOME Power Manager comes in three parts:

- gnome-settings-daemon plugin: the manager daemon itself
- gnome-control-center panel:   the control panel program, for configuration
- gnome-power-statistics:       the statistics graphing program


%prep
%setup

%build
%autoreconf
%configure \
    --enable-tests \
    --disable-schemas-compile

%make_build

%check
%make check

%install
%make_install DESTDIR=%buildroot install

# The license
ln -sf %_licensedir/GPL-2 COPYING

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/gnome-power-statistics
%_desktopdir/gnome-power-statistics.desktop
%_iconsdir/hicolor/*/*/*.png
%_iconsdir/hicolor/*/*/*.svg
%_iconsdir/HighContrast/*/*/*.png
%config %_datadir/glib-2.0/schemas/org.gnome.power-manager.gschema.xml
%_man1dir/*.1.gz
%doc --no-dereference COPYING
%doc README NEWS AUTHORS


%changelog
