%define ver_major 3.6
%def_disable static
%def_disable docbook
%def_enable consolekit
%def_with systemd

%define _libexecdir %_prefix/libexec

Name: gnome-screensaver
Version: %ver_major.1
Release: alt4

Summary: GNOME Screensaver
License: GPLv2+
Group: Graphical desktop/GNOME
Url: http://live.gnome.org/GnomeScreensaver
Packager: GNOME Maintainers Team <gnome at packages.altlinux.org>

Provides: screen-saver-engine
Provides: screen-saver-frontend
Provides: gnome-screensaver-module

Source: http://download.gnome.org/sources/gnome-screensaver/%ver_major/%name-%version.tar.xz

Patch: gnome-screensaver-2.28.0-alt-pam.patch
# https://bugzilla.gnome.org/show_bug.cgi?id=579430
Patch2: gnome-screensaver-2.28.0-user_activity.patch
Patch3: gnome-screensaver-3.6.1-alt-setuid.patch

# From configure.ac
%define dbus_ver 0.30
%define glib_ver 2.28.0
%define gtk_ver 3.0.2
%define desktop_ver 3.1.91
%define libgnomekbd_ver 2.91.91
%define systemd_ver 37

BuildPreReq: gnome-common
BuildPreReq: xscreensaver-devel
# From configure.ac
BuildPreReq: intltool >= 0.35
BuildPreReq: libdbus-glib-devel >= %dbus_ver libdbus-devel >= %dbus_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libgnome-desktop3-devel >= %desktop_ver
BuildPreReq: libgnomekbd-devel >= %libgnomekbd_ver
BuildRequires: libpam-devel gsettings-desktop-schemas-devel
BuildRequires: libXxf86vm-devel libSM-devel
BuildRequires:libXScrnSaver-devel libXext-devel libXtst-devel xorg-xf86vidmodeproto-devel
%{?_enable_docbook:Requires: xmlto}
%{?_with_systemd:BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel libsystemd-daemon-devel}

%description
gnome-screensaver is a screen saver and locker that aims to have
simple, sane, secure defaults and be well integrated with the desktop.


%prep
%setup -q
%patch -p1 -b .pam
%patch2 -p1 -b .user_activity
%patch3 -p1 -b .setuid

%build
%autoreconf
%configure  \
	%{subst_enable static} \
	--disable-schemas-compile \
	--enable-locking \
	--with-pam-prefix=%_sysconfdir \
	--with-kbd-layout-indicator \
	%{?_enable_docbook:--enable-docbook-docs} \
	%{?_enable_consolekit:--with-console-kit} \
	%{subst_with systemd}

%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/*
%attr(2711,root,chkpwd) %_libexecdir/%name-dialog
%_man1dir/*
%_sysconfdir/xdg/autostart/gnome-screensaver.desktop
%attr(640,root,chkpwd) %config(noreplace) %_sysconfdir/pam.d/*
%doc AUTHORS NEWS README

%changelog
