%define ver_major 3.8
%define _libexecdir %_prefix/libexec
%def_enable systemd
%def_enable session_selector

Name: gnome-session
Version: %ver_major.4
Release: alt1.M70P.2

Summary: The gnome session programs for the GNOME GUI desktop environment
License: GPLv2+
Group: Graphical desktop/GNOME
URL: ftp://ftp.gnome.org
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
#Source: %name-%version.tar
Source1: gnome.svg

Patch: %name-2.91.6-alt-autosave_session.patch
Patch1: %name-3.8.2-alt-lfs.patch

# fedora patches:
# Blacklist NV30: https://bugzilla.redhat.com/show_bug.cgi?id=745202
Patch11: gnome-session-3.3.92-nv30.patch

# From configure.in
%define glib_ver 2.35.0
%define gtk_ver 3.0.0
%define dbus_glib_ver 0.76
%define polkit_ver 0.91
%define upower_ver 0.9
%define systemd_ver 40

PreReq: xinitrc libcanberra-gnome libcanberra-gtk3
Requires: altlinux-freedesktop-menu-gnome3
Requires: dbus-tools-gui
Requires: gnome-filesystem
Requires: gnome-settings-daemon >= 3.0.0
Requires: upower gcr
Requires: xdg-user-dirs

Requires: icon-theme-hicolor gnome-icon-theme-symbolic gnome-themes-standard

BuildPreReq: rpm-build-gnome >= 0.5
BuildPreReq: gnome-common

# From configure.in
BuildPreReq: intltool >= 0.35.0 libGConf-devel
BuildPreReq: libgio-devel glib2-devel >= %glib_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
BuildPreReq: libdbus-glib-devel >= %dbus_glib_ver
BuildPreReq: libupower-devel >= %upower_ver
BuildRequires: libpangox-compat-devel libgnome-desktop3-devel librsvg-devel libjson-glib-devel
BuildRequires: libX11-devel libXau-devel libXrandr-devel libXrender-devel libXt-devel
BuildRequires: libSM-devel libXext-devel libXtst-devel libXi-devel libXcomposite-devel libGL-devel
BuildRequires: GConf browser-plugins-npapi-devel perl-XML-Parser xorg-xtrans-devel
BuildRequires: docbook-dtds docbook-style-xsl
%{?_enable_systemd:BuildRequires: systemd-devel >= %systemd_ver libsystemd-login-devel libsystemd-daemon-devel libsystemd-journal-devel libpolkit-devel}

%description

GNOME (GNU Network Object Model Environment) is a user-friendly set of
applications and desktop tools to be used in conjunction with a window
manager for the X Window System.

This package provides the GNOME session manager, as well as a
configuration program to choose applications starting on login.

%package selector
Summary: The session selector for the GNOME
Group: Graphical desktop/GNOME
Requires: %name = %EVR

%description selector
This package permits to choose a saved GNOME session.

%prep
%setup -q
%patch
%patch1 -p1 -b .lfs
%patch11 -p1 -b .nv30

[ ! -d m4 ] && mkdir m4

%build
%autoreconf
%configure PATH=$PATH:/sbin \
    %{subst_enable systemd} \
    %{?_enable_session_selector:--enable-session-selector} \
    --enable-ipv6 \
    --disable-schemas-compile

%make_build

%install
%makeinstall_std

cat <<__START_GNOME_COMMON__ >startgnome-common
#!/bin/sh

# turn on fonts antialiasing
export GDK_USE_XFT=1

# set default browser to whatever GNOME user likes
export BROWSER=gnome-open

# tell restored browsers where plugins are
export MOZ_PLUGIN_PATH="\${MOZ_PLUGIN_PATH:+"\$MOZ_PLUGIN_PATH:"}\${HOME:+"\$HOME/.mozilla/plugins:"}%_libdir/mozilla/plugins:%_libdir/netscape/plugins:%browser_plugins_path"

export HELP_BROWSER=yelp

# use prefixed .menu files
export XDG_MENU_PREFIX="gnome3-"

#### use /usr/share/gnome as a part of XDG_DATA_DIRS
#### export XDG_DATA_DIRS="\${XDG_DATA_DIRS:+"\$XDG_DATA_DIRS:"}%_datadir/gnome"

# Since shared-mime-info-0.90-alt3 XDG_DATA_DIRS not exported. We need to define
# the set of base directories explicitly.

export XDG_DATA_DIRS="%_datadir/gnome:%_datadir:/usr/local/share"

# to avoid gnome-shell crash
#/bin/rm -f "\$HOME"/.config/gnome-session/saved-session/gnome-shell.desktop >/dev/null 2>&1

# saved gnome-shell-classic.desktop is lacking --mode=classic due to gnome-session bug
desktop="\$HOME"/.config/gnome-session/saved-session/gnome-shell-classic.desktop
string="--mode=classic"
if [ -a "\$desktop" ]; then
grep -qs "\'\$string'" "\$desktop" || subst 's/\(Exec=gnome-shell\)/\1 '\$string'/' "\$desktop"
fi
__START_GNOME_COMMON__

cat <<__START_GNOME__ >startgnome
#!/bin/sh

. %_datadir/%name/startgnome-common

exec %_bindir/gnome-session "\$@"
__START_GNOME__

install -pD -m755 startgnome %buildroot%_bindir/startgnome
install -pD -m755 startgnome-common %buildroot%_datadir/%name/startgnome-common

mkdir -p %buildroot%_sysconfdir/X11/wmsession.d/
cat << __EOF__ > %buildroot%_sysconfdir/X11/wmsession.d/02Gnome
NAME=Gnome
ICON=%_iconsdir/gnome.svg
DESC=Gnome Environment
EXEC=%_bindir/startgnome
SCRIPT:
exec %_bindir/startgnome
__EOF__

%if_enabled session_selector
cat <<__START_GNOME__ >startgnome
#!/bin/sh

. %_datadir/gnome-session/startgnome-common

exec %_bindir/gnome-session-custom-session "\$@"
__START_GNOME__

install -pD -m755 startgnome %buildroot%_bindir/startgnome-custom

cat << __EOF__ > %buildroot%_sysconfdir/X11/wmsession.d/04Gnome-custom
NAME=Gnome-custom
ICON=%_iconsdir/gnome.svg
DESC=Gnome Session Selector
EXEC=%_bindir/startgnome-custom
SCRIPT:
exec %_bindir/startgnome-custom
__EOF__
%endif

install -pD -m644 %SOURCE1 %buildroot%_iconsdir/gnome.svg

%find_lang --with-gnome --output=%name.lang %name-3.0

%check
%make check

%files -f %name.lang
%_bindir/gnome-session
%_bindir/gnome-session-inhibit
%_bindir/gnome-session-properties
%_bindir/gnome-session-quit
%_bindir/startgnome
%_libexecdir/gnome-session-check-accelerated
%_libexecdir/gnome-session-check-accelerated-helper
%_libexecdir/gnome-session-failed
%_desktopdir/*.desktop
%dir %_datadir/%name
%_datadir/%name/gsm-inhibit-dialog.ui
%_datadir/%name/session-properties.ui
%_datadir/%name/hardware-compatibility
%_datadir/%name/startgnome-common
%dir %_datadir/%name/sessions
%_datadir/%name/sessions/gnome.session
%_datadir/%name/sessions/gnome-dummy.session
%_iconsdir/gnome.svg
%_iconsdir/hicolor/*/apps/session-properties.*
%config %_sysconfdir/X11/wmsession.d/02Gnome
%config %_datadir/glib-2.0/schemas/org.gnome.SessionManager.gschema.xml
%_datadir/GConf/gsettings/%name.convert
%_man1dir/gnome-session-inhibit.*
%_man1dir/gnome-session-properties.*
%_man1dir/gnome-session-quit.*
%_man1dir/gnome-session.*
%doc AUTHORS NEWS README

%exclude %_datadir/xsessions/gnome.desktop

%if_enabled session_selector
%files selector
%config %_sysconfdir/X11/wmsession.d/04Gnome-custom
%_bindir/startgnome-custom
%_bindir/gnome-session-custom-session
%_bindir/gnome-session-selector
%_datadir/%name/session-selector.ui
%_man1dir/gnome-session-selector.*
%exclude %_datadir/xsessions/gnome-custom-session.desktop
%endif

%changelog
